module Cabal.ReplOptions (
  Option(..)
, Argument(..)
, options
) where

import           Imports

data Option = Option {
  optionName :: String
, optionShortName :: Maybe Char
, optionArgument :: Argument
, optionHelp :: String
} deriving (Eq, Show)

data Argument = Argument String | NoArgument | OptionalArgument String
  deriving (Eq, Show)

options :: [Option]
options = [
    Option "help" (Just 'h') NoArgument "Show this help text"
  , Option "verbose" (Just 'v') (OptionalArgument "n") "Control verbosity (n is 0--3, default verbosity level is 1)"
  , Option "builddir" Nothing (Argument "DIR") "The directory where Cabal puts generated build files (default dist)"
  , Option "keep-temp-files" Nothing NoArgument "Keep temporary files."
  , Option "ghc" (Just 'g') NoArgument "compile with GHC"
  , Option "ghcjs" Nothing NoArgument "compile with GHCJS"
  , Option "uhc" Nothing NoArgument "compile with UHC"
  , Option "with-compiler" (Just 'w') (Argument "PATH") "give the path to a particular compiler"
  , Option "with-hc-pkg" Nothing (Argument "PATH") "give the path to the package tool"
  , Option "prefix" Nothing (Argument "DIR") "bake this prefix in preparation of installation"
  , Option "bindir" Nothing (Argument "DIR") "installation directory for executables"
  , Option "libdir" Nothing (Argument "DIR") "installation directory for libraries"
  , Option "libsubdir" Nothing (Argument "DIR") "subdirectory of libdir in which libs are installed"
  , Option "dynlibdir" Nothing (Argument "DIR") "installation directory for dynamic libraries"
  , Option "libexecdir" Nothing (Argument "DIR") "installation directory for program executables"
  , Option "libexecsubdir" Nothing (Argument "DIR") "subdirectory of libexecdir in which private executables are installed"
  , Option "datadir" Nothing (Argument "DIR") "installation directory for read-only data"
  , Option "datasubdir" Nothing (Argument "DIR") "subdirectory of datadir in which data files are installed"
  , Option "docdir" Nothing (Argument "DIR") "installation directory for documentation"
  , Option "htmldir" Nothing (Argument "DIR") "installation directory for HTML documentation"
  , Option "haddockdir" Nothing (Argument "DIR") "installation directory for haddock interfaces"
  , Option "sysconfdir" Nothing (Argument "DIR") "installation directory for configuration files"
  , Option "program-prefix" Nothing (Argument "PREFIX") "prefix to be applied to installed executables"
  , Option "program-suffix" Nothing (Argument "SUFFIX") "suffix to be applied to installed executables"
  , Option "enable-library-vanilla" Nothing NoArgument "Enable Vanilla libraries"
  , Option "disable-library-vanilla" Nothing NoArgument "Disable Vanilla libraries"
  , Option "enable-library-profiling" (Just 'p') NoArgument "Enable Library profiling"
  , Option "disable-library-profiling" Nothing NoArgument "Disable Library profiling"
  , Option "enable-shared" Nothing NoArgument "Enable Shared library"
  , Option "disable-shared" Nothing NoArgument "Disable Shared library"
  , Option "enable-static" Nothing NoArgument "Enable Static library"
  , Option "disable-static" Nothing NoArgument "Disable Static library"
  , Option "enable-executable-dynamic" Nothing NoArgument "Enable Executable dynamic linking"
  , Option "disable-executable-dynamic" Nothing NoArgument "Disable Executable dynamic linking"
  , Option "enable-executable-static" Nothing NoArgument "Enable Executable fully static linking"
  , Option "disable-executable-static" Nothing NoArgument "Disable Executable fully static linking"
  , Option "enable-profiling" Nothing NoArgument "Enable Executable and library profiling"
  , Option "disable-profiling" Nothing NoArgument "Disable Executable and library profiling"
  , Option "enable-profiling-shared" Nothing NoArgument "Enable Build profiling shared libraries"
  , Option "disable-profiling-shared" Nothing NoArgument "Disable Build profiling shared libraries"
  , Option "enable-executable-profiling" Nothing NoArgument "Enable Executable profiling (DEPRECATED)"
  , Option "disable-executable-profiling" Nothing NoArgument "Disable Executable profiling (DEPRECATED)"
  , Option "profiling-detail" Nothing (Argument "level") "Profiling detail level for executable and library (default, none, exported-functions, toplevel-functions, all-functions, late)."
  , Option "library-profiling-detail" Nothing (Argument "level") "Profiling detail level for libraries only."
  , Option "enable-optimization" (Just 'O') (OptionalArgument "n") "Build with optimization (n is 0--2, default is 1)"
  , Option "disable-optimization" Nothing NoArgument "Build without optimization"
  , Option "enable-debug-info" Nothing (OptionalArgument "n") "Emit debug info (n is 0--3, default is 0)"
  , Option "disable-debug-info" Nothing NoArgument "Don't emit debug info"
  , Option "enable-build-info" Nothing NoArgument "Enable build information generation during project building"
  , Option "disable-build-info" Nothing NoArgument "Disable build information generation during project building"
  , Option "enable-library-for-ghci" Nothing NoArgument "Enable compile library for use with GHCi"
  , Option "disable-library-for-ghci" Nothing NoArgument "Disable compile library for use with GHCi"
  , Option "enable-split-sections" Nothing NoArgument "Enable compile library code such that unneeded definitions can be dropped from the final executable (GHC 7.8+)"
  , Option "disable-split-sections" Nothing NoArgument "Disable compile library code such that unneeded definitions can be dropped from the final executable (GHC 7.8+)"
  , Option "enable-split-objs" Nothing NoArgument "Enable split library into smaller objects to reduce binary sizes (GHC 6.6+)"
  , Option "disable-split-objs" Nothing NoArgument "Disable split library into smaller objects to reduce binary sizes (GHC 6.6+)"
  , Option "enable-executable-stripping" Nothing NoArgument "Enable strip executables upon installation to reduce binary sizes"
  , Option "disable-executable-stripping" Nothing NoArgument "Disable strip executables upon installation to reduce binary sizes"
  , Option "enable-library-stripping" Nothing NoArgument "Enable strip libraries upon installation to reduce binary sizes"
  , Option "disable-library-stripping" Nothing NoArgument "Disable strip libraries upon installation to reduce binary sizes"
  , Option "configure-option" Nothing (Argument "OPT") "Extra option for configure"
  , Option "user" Nothing NoArgument "Enable doing a per-user installation"
  , Option "global" Nothing NoArgument "Disable doing a per-user installation"
  , Option "package-db" Nothing (Argument "DB") "Append the given package database to the list of package databases used (to satisfy dependencies and register into). May be a specific file, 'global' or 'user'. The initial list is ['global'], ['global', 'user'], or ['global', $sandbox], depending on context. Use 'clear' to reset the list to empty. See the user guide for details."
  , Option "flags" (Just 'f') (Argument "FLAGS") "Force values for the given flags in Cabal conditionals in the .cabal file. E.g., --flags=\"debug -usebytestrings\" forces the flag \"debug\" to true and \"usebytestrings\" to false."
  , Option "extra-include-dirs" Nothing (Argument "PATH") "A list of directories to search for header files"
  , Option "enable-deterministic" Nothing NoArgument "Enable Try to be as deterministic as possible (used by the test suite)"
  , Option "disable-deterministic" Nothing NoArgument "Disable Try to be as deterministic as possible (used by the test suite)"
  , Option "ipid" Nothing (Argument "IPID") "Installed package ID to compile this package as"
  , Option "cid" Nothing (Argument "CID") "Installed component ID to compile this component as"
  , Option "extra-lib-dirs" Nothing (Argument "PATH") "A list of directories to search for external libraries"
  , Option "extra-lib-dirs-static" Nothing (Argument "PATH") "A list of directories to search for external libraries when linking fully static executables"
  , Option "extra-framework-dirs" Nothing (Argument "PATH") "A list of directories to search for external frameworks (OS X only)"
  , Option "extra-prog-path" Nothing (Argument "PATH") "A list of directories to search for required programs (in addition to the normal search locations)"
  , Option "instantiate-with" Nothing (Argument "NAME=MOD") "A mapping of signature names to concrete module instantiations."
  , Option "enable-tests" Nothing NoArgument "Enable dependency checking and compilation for test suites listed in the package description file."
  , Option "disable-tests" Nothing NoArgument "Disable dependency checking and compilation for test suites listed in the package description file."
  , Option "enable-coverage" Nothing NoArgument "Enable build package with Haskell Program Coverage. (GHC only)"
  , Option "disable-coverage" Nothing NoArgument "Disable build package with Haskell Program Coverage. (GHC only)"
  , Option "enable-library-coverage" Nothing NoArgument "Enable build package with Haskell Program Coverage. (GHC only) (DEPRECATED)"
  , Option "disable-library-coverage" Nothing NoArgument "Disable build package with Haskell Program Coverage. (GHC only) (DEPRECATED)"
  , Option "enable-benchmarks" Nothing NoArgument "Enable dependency checking and compilation for benchmarks listed in the package description file."
  , Option "disable-benchmarks" Nothing NoArgument "Disable dependency checking and compilation for benchmarks listed in the package description file."
  , Option "enable-relocatable" Nothing NoArgument "Enable building a package that is relocatable. (GHC only)"
  , Option "disable-relocatable" Nothing NoArgument "Disable building a package that is relocatable. (GHC only)"
  , Option "disable-response-files" Nothing NoArgument "enable workaround for old versions of programs like \"ar\" that do not support @file arguments"
  , Option "allow-depending-on-private-libs" Nothing NoArgument "Allow depending on private libraries. If set, the library visibility check MUST be done externally."
  , Option "coverage-for" Nothing (Argument "UNITID") "A list of unit-ids of libraries to include in the Haskell Program Coverage report."
  , Option "ignore-build-tools" Nothing NoArgument "Ignore build tool dependencies. If set, declared build tools needn't be found for compilation to proceed."
  , Option "cabal-lib-version" Nothing (Argument "VERSION") "Select which version of the Cabal lib to use to build packages (useful for testing)."
  , Option "enable-append" Nothing NoArgument "Enable appending the new config to the old config file"
  , Option "disable-append" Nothing NoArgument "Disable appending the new config to the old config file"
  , Option "enable-backup" Nothing NoArgument "Enable the backup of the config file before any alterations"
  , Option "disable-backup" Nothing NoArgument "Disable the backup of the config file before any alterations"
  , Option "constraint" (Just 'c') (Argument "CONSTRAINT") "Specify constraints on a package (version, installed/source, flags)"
  , Option "preference" Nothing (Argument "CONSTRAINT") "Specify preferences (soft constraints) on the version of a package"
  , Option "solver" Nothing (Argument "SOLVER") "Select dependency solver to use (default: modular). Choices: modular."
  , Option "allow-older" Nothing (OptionalArgument "DEPS") "Ignore lower bounds in all dependencies or DEPS"
  , Option "allow-newer" Nothing (OptionalArgument "DEPS") "Ignore upper bounds in all dependencies or DEPS"
  , Option "write-ghc-environment-files" Nothing (Argument "always|never|ghc8.4.4+") "Whether to create a .ghc.environment file after a successful build (v2-build only)"
  , Option "enable-documentation" Nothing NoArgument "Enable building of documentation"
  , Option "disable-documentation" Nothing NoArgument "Disable building of documentation"
  , Option "doc-index-file" Nothing (Argument "TEMPLATE") "A central index of haddock API documentation (template cannot use $pkgid)"
  , Option "dry-run" Nothing NoArgument "Do not install anything, only print what would be installed."
  , Option "only-download" Nothing NoArgument "Do not build anything, only fetch the packages."
  , Option "max-backjumps" Nothing (Argument "NUM") "Maximum number of backjumps allowed while solving (default: 4000). Use a negative number to enable unlimited backtracking. Use 0 to disable backtracking completely."
  , Option "reorder-goals" Nothing NoArgument "Try to reorder goals according to certain heuristics. Slows things down on average, but may make backtracking faster for some packages."
  , Option "count-conflicts" Nothing NoArgument "Try to speed up solving by preferring goals that are involved in a lot of conflicts (default)."
  , Option "fine-grained-conflicts" Nothing NoArgument "Skip a version of a package if it does not resolve the conflicts encountered in the last version, as a solver optimization (default)."
  , Option "minimize-conflict-set" Nothing NoArgument "When there is no solution, try to improve the error message by finding a minimal conflict set (default: false). May increase run time significantly."
  , Option "independent-goals" Nothing NoArgument "Treat several goals on the command line as independent. If several goals depend on the same package, different versions can be chosen."
  , Option "prefer-oldest" Nothing NoArgument "Prefer the oldest (instead of the latest) versions of packages available. Useful to determine lower bounds in the build-depends section."
  , Option "shadow-installed-packages" Nothing NoArgument "If multiple package instances of the same version are installed, treat all but one as shadowed."
  , Option "strong-flags" Nothing NoArgument "Do not defer flag choices (this used to be the default in cabal-install <= 1.20)."
  , Option "allow-boot-library-installs" Nothing NoArgument "Allow cabal to install base, ghc-prim, integer-simple, integer-gmp, and template-haskell."
  , Option "reject-unconstrained-dependencies" Nothing (Argument "none|all") "Require these packages to have constraints on them if they are to be selected (default: none)."
  , Option "reinstall" Nothing NoArgument "Install even if it means installing the same version again."
  , Option "avoid-reinstalls" Nothing NoArgument "Do not select versions that would destructively overwrite installed packages."
  , Option "force-reinstalls" Nothing NoArgument "Reinstall packages even if they will most likely break other installed packages."
  , Option "upgrade-dependencies" Nothing NoArgument "Pick the latest version for all dependencies, rather than trying to pick an installed version."
  , Option "only-dependencies" Nothing NoArgument "Install only the dependencies necessary to build the given packages"
  , Option "dependencies-only" Nothing NoArgument "A synonym for --only-dependencies"
  , Option "index-state" Nothing (Argument "STATE") "Use source package index state as it existed at a previous time. Accepts unix-timestamps (e.g. '@1474732068'), ISO8601 UTC timestamps (e.g. '2016-09-24T17:47:48Z'), or 'HEAD' (default: 'HEAD')."
  , Option "root-cmd" Nothing (Argument "COMMAND") "(No longer supported, do not use.)"
  , Option "build-summary" Nothing (Argument "TEMPLATE") "Save build summaries to file (name template can use $pkgid, $compiler, $os, $arch)"
  , Option "build-log" Nothing (Argument "TEMPLATE") "Log all builds to file (name template can use $pkgid, $compiler, $os, $arch)"
  , Option "remote-build-reporting" Nothing (Argument "LEVEL") "Generate build reports to send to a remote server (none, anonymous or detailed)."
  , Option "report-planning-failure" Nothing NoArgument "Generate build reports when the dependency solver fails. This is used by the Hackage build bot."
  , Option "enable-per-component" Nothing NoArgument "Enable Per-component builds when possible"
  , Option "disable-per-component" Nothing NoArgument "Disable Per-component builds when possible"
  , Option "run-tests" Nothing NoArgument "Run package test suites during installation."
  , Option "semaphore" Nothing NoArgument "Use a semaphore so GHC can compile components in parallel"
  , Option "jobs" (Just 'j') (OptionalArgument "NUM") "Run NUM jobs simultaneously (or '$ncpus' if no NUM is given)."
  , Option "keep-going" Nothing NoArgument "After a build failure, continue to build other unaffected packages."
  , Option "offline" Nothing NoArgument "Don't download packages from the Internet."
  , Option "haddock-hoogle" Nothing NoArgument "Generate a hoogle database"
  , Option "haddock-html" Nothing NoArgument "Generate HTML documentation (the default)"
  , Option "haddock-html-location" Nothing (Argument "URL") "Location of HTML documentation for pre-requisite packages"
  , Option "haddock-for-hackage" Nothing NoArgument "Collection of flags to generate documentation suitable for upload to hackage"
  , Option "haddock-executables" Nothing NoArgument "Run haddock for Executables targets"
  , Option "haddock-tests" Nothing NoArgument "Run haddock for Test Suite targets"
  , Option "haddock-benchmarks" Nothing NoArgument "Run haddock for Benchmark targets"
  , Option "haddock-all" Nothing NoArgument "Run haddock for all targets"
  , Option "haddock-internal" Nothing NoArgument "Run haddock for internal modules and include all symbols"
  , Option "haddock-css" Nothing (Argument "PATH") "Use PATH as the haddock stylesheet"
  , Option "haddock-hyperlink-source" Nothing NoArgument "Hyperlink the documentation to the source code"
  , Option "haddock-quickjump" Nothing NoArgument "Generate an index for interactive documentation navigation"
  , Option "haddock-hscolour-css" Nothing (Argument "PATH") "Use PATH as the HsColour stylesheet"
  , Option "haddock-contents-location" Nothing (Argument "URL") "Bake URL in as the location for the contents page"
  , Option "haddock-base-url" Nothing (Argument "URL") "Base URL for static files."
  , Option "haddock-resources-dir" Nothing (Argument "DIR") "location of Haddocks static / auxiliary files"
  , Option "haddock-output-dir" Nothing (Argument "DIR") "Generate haddock documentation into this directory. This flag is provided as a technology preview and is subject to change in the next releases."
  , Option "haddock-use-unicode" Nothing NoArgument "Pass --use-unicode option to haddock"
  , Option "test-log" Nothing (Argument "TEMPLATE") "Log all test suite results to file (name template can use $pkgid, $compiler, $os, $arch, $test-suite, $result)"
  , Option "test-machine-log" Nothing (Argument "TEMPLATE") "Produce a machine-readable log file (name template can use $pkgid, $compiler, $os, $arch, $result)"
  , Option "test-show-details" Nothing (Argument "FILTER") "'always': always show results of individual test cases. 'never': never show results of individual test cases. 'failures': show results of failing test cases. 'streaming': show results of test cases in real time.'direct': send results of test cases in real time; no log file."
  , Option "test-keep-tix-files" Nothing NoArgument "keep .tix files for HPC between test runs"
  , Option "test-wrapper" Nothing (Argument "FILE") "Run test through a wrapper."
  , Option "test-fail-when-no-test-suites" Nothing NoArgument "Exit with failure when no test suites are found."
  , Option "test-options" Nothing (Argument "TEMPLATES") "give extra options to test executables (split on spaces, use \"\" to prevent splitting; name templates can use $pkgid, $compiler, $os, $arch, $test-suite)"
  , Option "test-option" Nothing (Argument "TEMPLATE") "give extra option to test executables (passed directly as a single argument; name template can use $pkgid, $compiler, $os, $arch, $test-suite)"
  , Option "benchmark-options" Nothing (Argument "TEMPLATES") "give extra options to benchmark executables (split on spaces, use \"\" to prevent splitting; name templates can use $pkgid, $compiler, $os, $arch, $benchmark)"
  , Option "benchmark-option" Nothing (Argument "TEMPLATE") "give extra option to benchmark executables (passed directly as a single argument; name template can use $pkgid, $compiler, $os, $arch, $benchmark)"
  , Option "project-dir" Nothing (Argument "DIR") "Set the path of the project directory"
  , Option "project-file" Nothing (Argument "FILE") "Set the path of the cabal.project file (relative to the project directory when relative)"
  , Option "ignore-project" (Just 'z') NoArgument "Ignore local project configuration (unless --project-dir or --project-file is also set)"
  , Option "repl-no-load" Nothing NoArgument "Disable loading of project modules at REPL startup."
  , Option "repl-options" Nothing (Argument "FLAG") "Use the option(s) for the repl"
  , Option "repl-multi-file" Nothing (Argument "DIR") "Write repl options to this directory rather than starting repl mode"
  , Option "with-repl" Nothing (Argument "PATH") "Give the path to a program to use for REPL"
  , Option "build-depends" (Just 'b') (Argument "DEPENDENCIES") "Include additional packages in the environment presented to GHCi."
  , Option "no-transitive-deps" Nothing NoArgument "Don't automatically include transitive dependencies of requested packages."
  , Option "enable-multi-repl" Nothing NoArgument "Enable multi-component repl sessions"
  , Option "disable-multi-repl" Nothing NoArgument "Disable multi-component repl sessions"
  ]
