

--------------------------------------------------------------------------------
-- |
--
-- Module      :  Data.Act
-- Description :  Actions of sets, semigroups, monoids or groups.
-- Copyright   :  (c) Alice Rixte 2024
-- License     :  BSD 3
-- Maintainer  :  alice.rixte@u-bordeaux.fr
-- Stability   :  unstable
-- Portability :  non-portable (GHC extensions)
--
-- == Presentation
--
-- An action lifts an element (the "/actor/") of some type @s@, the /acting/
-- type, into a function of another type @x@ which we call the "/actee/".
--
-- The class hierarchy for actions is fine-grained, which means it is flexible
-- but sometimes cumbersome to deal with. In particular, this allows to specify
-- specific properties on the action for a semidirect product to be a semigroup
-- or a monoid (see @'Data.Semidirect'@). Here is a tree summarizing the class
-- hierarchy and their laws:
--
-- @
-- 'LAct'                     /Set action/
--  => 'LActSg'               /Semigroup action/
--      => 'LActMn'           /Monoid action/
--           => 'LTorsor'     /Torsor/
--  => 'LActDistrib'          /Distributive action/
--  => 'LActNeutral'          /Neutral preserving action/
--  => 'LActGen'              /Action generated by a set/
--      => 'LActCyclic'       /Cyclic action (generated by a single element)/
-- @
--
--
-- == Instances driven by the acting type
--
-- The action classes do not have functional dependencies, which can make it
-- awkward to work with them. To avoid overlapping issues, this library chooses
-- to drive instances by the second parameter, i.e. to _never_ write instances
-- of the form
--
-- @
-- instance LAct SomeType s
-- instance RAct SomeType s
-- @
--
--
-- If you need such an instance, you should make a newtype. This library already
-- provides some, such as @'ActSelf'@,  @'ActTrivial'@, @'ActSelf''@, @'ActFold''@
-- and @'ActMap'@.
--
-- == Design choices compared to existing libraries
--
-- This library is inspired by the already existing action libraries.
--
-- * The deriving mechanism is inspired by the one from the @acts@ library. The
--   main difference between this library and the @acts@ library is that  @acts@
--   drives its instances by the actee parameter.
--
-- * The @monoid-extras@ library drives its instances by the acting type, but
--   does not provide a deriving mechanism. This library started as an extension
--   of @monoid-extras@, but the design choices made it diverge from it.
--
-- * The idea of specifying action properties using empty classes comes from the
--   @semigroups-actions@ library, which inspired some design of this library.
--   This library offers everything @semigroups-actions@ offers, and more.
--
--------------------------------------------------------------------------------

module Data.Act
  ( module Data.Act.Act
  , module Data.Act.Torsor
  , module Data.Act.Cyclic
  ) where

import Data.Act.Act
import Data.Act.Torsor
import Data.Act.Cyclic