{ pkgs ? import <nixpkgs> {}
, inputs ? {}
, ghc ? null
, withHoogle ? false
}:
let
  haskellPackages =
    if ghc == null
    then pkgs.haskellPackages
    else pkgs.haskell.packages.${ghc};
  hs = haskellPackages.extend (with pkgs.haskell.lib; hself: hsuper:
    {
      reloto = buildFromSdist (hself.callCabal2nix "reloto" ./. {});
    }
  );
in hs.reloto // {
  shell = hs.shellFor {
    packages = p: [ p.reloto ];
    nativeBuildInputs = [
      hs.cabal-install
      hs.ghcid
      hs.hlint
      #hs.haskell-language-server
    ];
    buildInputs = [
    ];
    inherit withHoogle;
  };
}
