-- | Tirages.
module Reloto.Draw where

import Data.Bool
import Prelude (Integer, Integral(..), Num(..))
import Data.List (length, map)

import Reloto.Bits
import Reloto.Combin
import Reloto.Sequence

-- | @unorderedDraw k xs bs@ retourne 'k' choix (sans ordre ni répétition) parmi 'xs'
-- déterminés par l’entropie 'bs'.
unorderedDraw :: Integer -> [a] -> [Bool] -> [a]
unorderedDraw k xs bs = map fromInteger (combinOfRank n k r) `permute` xs
  where n = toInteger (length xs)
        r = randomIntegerOfBits (n`nCk`k) bs

-- | @orderedDraw k xs bs@ retourne 'k' choix (avec ordre mais sans répétition) parmi 'xs'
-- déterminés par l’entropie 'bs'.
orderedDraw :: Integer -> [a] -> [Bool] -> [a]
orderedDraw k xs bs = map fromInteger (sequenceOfRank n k r) `permute` xs
  where n = toInteger (length xs)
        r = randomIntegerOfBits (n`nAk`k) bs
