Tutoriel de htirage
===================

On commence par les entêtes nécessaires au compilateur :

> {-# OPTIONS_GHC -fno-warn-missing-signatures #-}
> module Reloto.Tutorial where
> import Reloto
> import Prelude (toInteger)
> import Data.List ((++), length, sort)


2 parmi 5
---------

Pour sélectionner 2 choix parmi 5 (ordonnés lexicographiquement) :

> x0 = sort ["dominique", "claude", "baya", "zhennan", "camille"]
> n0 = length x0
> k0 = 2

Il faut au moins c0 == 3 bits équiprobables :

> c0 = equiprobableBits (toInteger n0`nCk`k0)

Ce tirage de lotterie en procure length b0 == 23:

> b0 = randomOf6aus49 (39,2,19,41,6,30) 9

Et on obtient s0 == ["baya","claude"] :

> s0 = unorderedDraw k0 x0 b0



42 parmi 100
------------

Pour sélectionner 42 choix parmi 100 :

> n1 = 100
> k1 = 42

Il faut au moins c1 == 94 bits équiprobables :

> c1 = equiprobableBits (n1`nCk`k1)

Ces quatres tirages de lotterie en procurent length b1 == 97 :

> b1 = randomOf6aus49 (27,2,12,34,22,19) 1 ++
>      randomOfEuroMillions (5,14,35,16,10) (2,7) ++
>      randomOfFrenchLoto (14,8,26,3,24) 2 ++
>      randomOfSwissLoto (17,2,29,37,30,25) 5

Et on obtient s1 == [1,8,9,10,11,12,17,19,20,21,25,26,28,32,35,37,46,50
                    ,51,52,54,55,57,60,61,63,65,66,67,69,70,73,74,75,78
                    ,80,83,87,89,90,92,97]

> s1 = unorderedDraw k1 [1..n1] b1
