-- |
-- Module: WildBind.X11.KeySym
-- Description: Re-export KeySyms
-- Maintainer: Toshio Ito <debug.ito@gmail.com>
--
-- This module re-exports X11 'KeySym's.
--
-- @since 0.2.0.0
module WildBind.X11.KeySym
    ( -- * The type
      KeySym
      -- * Alphabet
    , xK_a
    , xK_b
    , xK_c
    , xK_d
    , xK_e
    , xK_f
    , xK_g
    , xK_h
    , xK_i
    , xK_j
    , xK_k
    , xK_l
    , xK_m
    , xK_n
    , xK_o
    , xK_p
    , xK_q
    , xK_r
    , xK_s
    , xK_t
    , xK_u
    , xK_v
    , xK_w
    , xK_x
    , xK_y
    , xK_z
    , xK_A
    , xK_B
    , xK_C
    , xK_D
    , xK_E
    , xK_F
    , xK_G
    , xK_H
    , xK_I
    , xK_J
    , xK_K
    , xK_L
    , xK_M
    , xK_N
    , xK_O
    , xK_P
    , xK_Q
    , xK_R
    , xK_S
    , xK_T
    , xK_U
    , xK_V
    , xK_W
    , xK_X
    , xK_Y
    , xK_Z
      -- * Numbers
    , xK_0
    , xK_1
    , xK_2
    , xK_3
    , xK_4
    , xK_5
    , xK_6
    , xK_7
    , xK_8
    , xK_9
      -- * ASCII symbols
    , xK_space
    , xK_exclam
    , xK_quotedbl
    , xK_numbersign
    , xK_dollar
    , xK_percent
    , xK_ampersand
    , xK_apostrophe
    , xK_quoteright
    , xK_parenleft
    , xK_parenright
    , xK_asterisk
    , xK_plus
    , xK_comma
    , xK_minus
    , xK_period
    , xK_slash
    , xK_colon
    , xK_semicolon
    , xK_less
    , xK_equal
    , xK_greater
    , xK_question
    , xK_at
    , xK_bracketleft
    , xK_backslash
    , xK_bracketright
    , xK_asciicircum
    , xK_underscore
    , xK_grave
    , xK_quoteleft
    , xK_braceleft
    , xK_bar
    , xK_braceright
    , xK_asciitilde
      -- * Control keys
    , xK_BackSpace
    , xK_Tab
    , xK_Linefeed
    , xK_Clear
    , xK_Return
    , xK_Pause
    , xK_Scroll_Lock
    , xK_Sys_Req
    , xK_Escape
    , xK_Delete
    , xK_Multi_key
    , xK_Codeinput
    , xK_SingleCandidate
    , xK_MultipleCandidate
    , xK_PreviousCandidate
    , xK_Home
    , xK_Left
    , xK_Up
    , xK_Right
    , xK_Down
    , xK_Prior
    , xK_Page_Up
    , xK_Next
    , xK_Page_Down
    , xK_End
    , xK_Begin
    , xK_Select
    , xK_Print
    , xK_Execute
    , xK_Insert
    , xK_Undo
    , xK_Redo
    , xK_Menu
    , xK_Find
    , xK_Cancel
    , xK_Help
    , xK_Break
    , xK_Mode_switch
    , xK_script_switch
    , xK_Num_Lock
      -- * Number pad keys
    , xK_KP_Space
    , xK_KP_Tab
    , xK_KP_Enter
    , xK_KP_F1
    , xK_KP_F2
    , xK_KP_F3
    , xK_KP_F4
    , xK_KP_Home
    , xK_KP_Left
    , xK_KP_Up
    , xK_KP_Right
    , xK_KP_Down
    , xK_KP_Prior
    , xK_KP_Page_Up
    , xK_KP_Next
    , xK_KP_Page_Down
    , xK_KP_End
    , xK_KP_Begin
    , xK_KP_Insert
    , xK_KP_Delete
    , xK_KP_Equal
    , xK_KP_Multiply
    , xK_KP_Add
    , xK_KP_Separator
    , xK_KP_Subtract
    , xK_KP_Decimal
    , xK_KP_Divide
    , xK_KP_0
    , xK_KP_1
    , xK_KP_2
    , xK_KP_3
    , xK_KP_4
    , xK_KP_5
    , xK_KP_6
    , xK_KP_7
    , xK_KP_8
    , xK_KP_9
      -- * Function keys
    , xK_F1
    , xK_F2
    , xK_F3
    , xK_F4
    , xK_F5
    , xK_F6
    , xK_F7
    , xK_F8
    , xK_F9
    , xK_F10
    , xK_F11
    , xK_L1
    , xK_F12
    , xK_L2
    , xK_F13
    , xK_L3
    , xK_F14
    , xK_L4
    , xK_F15
    , xK_L5
    , xK_F16
    , xK_L6
    , xK_F17
    , xK_L7
    , xK_F18
    , xK_L8
    , xK_F19
    , xK_L9
    , xK_F20
    , xK_L10
    , xK_F21
    , xK_R1
    , xK_F22
    , xK_R2
    , xK_F23
    , xK_R3
    , xK_F24
    , xK_R4
    , xK_F25
    , xK_R5
    , xK_F26
    , xK_R6
    , xK_F27
    , xK_R7
    , xK_F28
    , xK_R8
    , xK_F29
    , xK_R9
    , xK_F30
    , xK_R10
    , xK_F31
    , xK_R11
    , xK_F32
    , xK_R12
    , xK_F33
    , xK_R13
    , xK_F34
    , xK_R14
    , xK_F35
    , xK_R15
      -- * Modifier keys
    , xK_Shift_L
    , xK_Shift_R
    , xK_Control_L
    , xK_Control_R
    , xK_Caps_Lock
    , xK_Shift_Lock
    , xK_Meta_L
    , xK_Meta_R
    , xK_Alt_L
    , xK_Alt_R
    , xK_Super_L
    , xK_Super_R
    , xK_Hyper_L
    , xK_Hyper_R
      -- * Alphabet with accent and ligatures
    , xK_Agrave
    , xK_Aacute
    , xK_Acircumflex
    , xK_Atilde
    , xK_Adiaeresis
    , xK_Aring
    , xK_AE
    , xK_Ccedilla
    , xK_Egrave
    , xK_Eacute
    , xK_Ecircumflex
    , xK_Ediaeresis
    , xK_Igrave
    , xK_Iacute
    , xK_Icircumflex
    , xK_Idiaeresis
    , xK_ETH
    , xK_Eth
    , xK_Ntilde
    , xK_Ograve
    , xK_Oacute
    , xK_Ocircumflex
    , xK_Otilde
    , xK_Odiaeresis
    , xK_multiply
    , xK_Ooblique
    , xK_Ugrave
    , xK_Uacute
    , xK_Ucircumflex
    , xK_Udiaeresis
    , xK_Yacute
    , xK_THORN
    , xK_Thorn
    , xK_ssharp
    , xK_agrave
    , xK_aacute
    , xK_acircumflex
    , xK_atilde
    , xK_adiaeresis
    , xK_aring
    , xK_ae
    , xK_ccedilla
    , xK_egrave
    , xK_eacute
    , xK_ecircumflex
    , xK_ediaeresis
    , xK_igrave
    , xK_iacute
    , xK_icircumflex
    , xK_idiaeresis
    , xK_eth
    , xK_ntilde
    , xK_ograve
    , xK_oacute
    , xK_ocircumflex
    , xK_otilde
    , xK_odiaeresis
    , xK_division
    , xK_oslash
    , xK_ugrave
    , xK_uacute
    , xK_ucircumflex
    , xK_udiaeresis
    , xK_yacute
    , xK_thorn
    , xK_ydiaeresis
      -- * Other symbols
    , xK_nobreakspace
    , xK_exclamdown
    , xK_cent
    , xK_sterling
    , xK_currency
    , xK_yen
    , xK_brokenbar
    , xK_section
    , xK_diaeresis
    , xK_copyright
    , xK_ordfeminine
    , xK_guillemotleft
    , xK_notsign
    , xK_hyphen
    , xK_registered
    , xK_macron
    , xK_degree
    , xK_plusminus
    , xK_twosuperior
    , xK_threesuperior
    , xK_acute
    , xK_mu
    , xK_paragraph
    , xK_periodcentered
    , xK_cedilla
    , xK_onesuperior
    , xK_masculine
    , xK_guillemotright
    , xK_onequarter
    , xK_onehalf
    , xK_threequarters
    , xK_questiondown
      -- * special keysym
    , xK_VoidSymbol
    ) where

import           Graphics.X11.Xlib
