module Footnotes_js where
content = "function inlineFootnote(footnote) {\n    var ref = document.getElementById(\"a-\" + footnote.id);\n    var inline = document.createElement(\"div\");\n    for (var i=0; i<footnote.children.length;) {\n        var child = footnote.children[i];\n        if (child.tagName == \"A\" && child.getAttribute(\"href\") == \"#\" + ref.id) {\n            i++;\n            continue;\n        }\n        inline.appendChild(child);\n    }\n    inline.className = \"inline-footnote\";\n    inline.style.display = \"none\";\n    ref.parentNode.parentNode.insertBefore(inline, ref.parentNode.nextSibling);\n    ref.origIndex = ref.textContent;\n    ref.expanded = false;\n    ref.addEventListener(\"click\", function (e) {\n        e.preventDefault();\n        if (ref.expanded) {\n            inline.style.display = \"none\";\n            ref.textContent = ref.origIndex;\n        } else {\n            inline.style.display = \"block\";\n            ref.textContent = \"X\";\n        }\n        ref.expanded = !ref.expanded;\n    });\n}\n\nfunction inlineFootnotes() {\n    var footnoteLists = document.getElementsByClassName(\"footnotes\");\n    while (footnoteLists.length > 0) {\n        var footnotes = footnoteLists[0].children;\n        for (var j=0; j<footnotes.length; j++) {\n            inlineFootnote(footnotes[j]);\n        }\n        footnoteLists[0].remove();\n    }\n}\n\ninlineFootnotes()\n"