{-# OPTIONS -Wall #-}
module DataTreeView.SimpleView where
import Graphics.UI.Gtk
import Data.Data
import Data.Monoid
import Control.Monad.Trans

import DataTreeView.Widget
import DataTreeView.DataToTree

simpleView ::  Data d => [d] -> IO ()
simpleView = simpleViewWithCH mempty

simpleViewWithCH ::  Data d => CustomHandler -> [d] -> IO ()
simpleViewWithCH ch xs = do
   _ <- initGUI
   window <- windowNew
   _ <- window `on` deleteEvent $ liftIO (mainQuit >> return False)
   
   dtv <- dtvNewWithCH ch xs

   set window [ windowTypeHint := WindowTypeHintNormal
              , containerChild := dtv ]

   -- i.e., on window deleteEvent (liftIO mainQuit >> return False)
   widgetShowAll window
   mainGUI


