#! env perl

# ###################################################################### Otakar Smrz, 2006/11/13
#
# Building Encode ##############################################################################

# $Id: Setup.PL 808 2009-02-09 23:19:07Z smrz $

our $VERSION = join '.', 1, 2, q $Revision: 808 $ =~ /(\d+)/;


use File::Spec;
use File::Copy;


sub path ($) {

    return File::Spec->join(split ' ', $_[0]);
}

    $DdotsEncodeExecbin = path "..... Encode bin";

    $Ddots = path ".....";
    
    $Dbin = path ". bin";
    $Ddoc = path ". doc";

    $fLICENSE = path ". LICENSE";
    $fSOURCE = path ". SOURCE";

    $\ = "\n";


    $file = path ". Encode.cabal";

    open C, '<', $file or die "Cannot open " . $file . "!\n";

    while (<C>) {

        $ver        = $1 if /^\s* version     \s* : \s* ([^\s]+) \s*$/ix;
        $url        = $1 if /^\s* package-url \s* : \s* ([^\s]+) \s*$/ix;
        $author     = $1 if /^\s* author      \s* : \s* ([^\s]+\ [^\s]+)\s*$/ix;
        $maintainer = $1 if /^\s* maintainer  \s* : \s* ([^\s]+\ [^\s]+)\s*$/ix;
        $homepage   = $1 if /^\s* homepage    \s* : \s* ([^\s]+) \s*$/ix;
        $copyright  = $1 if /^\s* copyright   \s* : \s* ([^\s]+) \s*$/ix;
    }

    close C;

    die "Version not recognized!\n"     unless $ver;
    die "Package-URL not recognized!\n" unless $url;
    die "Author not recognized!\n"      unless $author;
    die "Maintainer not recognized!\n"  unless $maintainer;
    die "Homepage not recognized!\n"    unless $homepage;
    die "Copyright not recognized!\n"   unless $copyright;


    mkdir "dist" unless -d "dist";

    print "Changing directory: dist";
    chdir "dist";


    print "Removing ...";

    foreach $file ((glob path "Encode doc decode *"),
                   (glob path "Encode doc encode *"),
                   (glob path "Encode doc *"),
                   (glob path "Encode bin *"),
                   (glob path "Encode *")) {

        print '  <- ' . $file;

        unlink $file;
    }

    rmdir path "Encode doc decode";
    rmdir path "Encode doc encode";
    rmdir path "Encode doc";
    rmdir path "Encode bin";
    rmdir path "Encode";

    die "Remove the " . ( path "dist Encode" ). " directory first!\n" if -d "Encode";

    mkdir path "Encode";
    mkdir path "Encode bin";
    mkdir path "Encode doc";
    mkdir path "Encode doc encode";
    mkdir path "Encode doc decode";


    print "Changing directory: ..";
    chdir "..";


    @param = @ARGV ? @ARGV : $^O eq 'MSWin32' ? "--global" 
                                              : "--user --prefix $ENV{'HOME'}/.cabal";
    
    print "Configuring with parameters: @param";
    
    system "runhaskell Setup.hs configure @param";
    system "runhaskell Setup.hs build";
    system "runhaskell Setup.hs haddock --executables";
    system "runhaskell Setup.hs install";
    system "runhaskell Setup.hs sdist";


    print "Changing directory: dist";
    chdir "dist";


    $path = path "Encode bin";

    print $path;

    @execs = $^O eq 'MSWin32' ? (path "build encode encode.exe", path "build decode decode.exe")
                              : (path "build encode encode",     path "build decode decode");

    foreach $file (@execs) {

        print '  <- ' . $file;

        copy $file, $path;
    }


    $path = path "Encode doc encode";

    print $path;

    foreach $file (glob path "doc html Encode encode *") {

        print '  <- ' . $file;

        move $file, $path;
    }


    $path = path "Encode doc decode";

    print $path;

    foreach $file (glob path "doc html Encode decode *") {

        print '  <- ' . $file;

        move $file, $path;
    }


    copy path ".. LICENSE", path "Encode";


    open S, '>', path "Encode SOURCE";

    print S << "SOURCE";

This software is distributed under the GNU General Public License in $fLICENSE.
The source code for this software can be downloaded from the following address:

    $url

If experiencing problems, please contact the maintainer of the software:

    $author <$maintainer>
    $homepage

Copyright (C) $copyright  $author
SOURCE

    close S;


    open I, '>', path "Encode INSTALL";

    print I << "INSTALL";

This package includes the $^O-built executables of the "Encode-$ver" library:

    $url

Before using the programs in the $Dbin directory, please read the license terms
in $fLICENSE and $fSOURCE. The HTML documentation is in the $Ddoc directories.

In order to run the programs, unpack the contents of the distribution package
and then:

either  execute the programs from within the $Dbin directory

    or  copy the contents of the $Dbin directory to some other directory that
        is already included in the PATH environment variable

    or  extend the setting of the PATH variable with $DdotsEncodeExecbin, where
        $Ddots stands for the actual path to the unpacked distribution

If experiencing problems, please contact the maintainer of the software:

    $author <$maintainer>
    $homepage

Copyright (C) $copyright  $author
INSTALL

    close I;


    $name = "Encode-" . $ver . "-Exec-" . $^O;

    system "tar -cf " . $name . ".tar" . " Encode";

    system "gzip -9 " . $name . ".tar";

    print "Done with " . $name . ".tar.gz";

    system "zip -r " . $name . ".zip" . " Encode";

    print "Done with " . $name . ".zip";
