![UI](ui.gif)

![Caminandes: Gran Dillama - Blender Foundation](sample.gif)  
Credit: [Caminandes: Gran Dillama - Blender Foundation](http://www.caminandes.com/)

# Gifcurry

## Description

Create animated GIFs, overlaid with optional text, from movies.

## CLI Usage

```bash
gifcurry ./in.mp4 ./out.gif start_second duration quality 'Optional top text.' 'Optional bottom text.'
```

## CLI Example

```Bash
~/gifcurry ❯❯❯ gifcurry ./02_gran_dillama_1080p.mp4 ./out.gif 32 8 500 100 'What is' 'Gifcurry?'
 _____ _  __                           
|  __ (_)/ _|                          
| |  \/_| |_ ___ _   _ _ __ _ __ _   _ 
| | __| |  _/ __| | | | '__| '__| | | |
| |_\ \ | || (__| |_| | |  | |  | |_| |
 \____/_|_| \___|\__,_|_|  |_|   \__, |
                                  __/ |
                                 |___/ 

Gifcurry (C) 2016 David Lettier. http://www.lettier.com/

Input file: ./02_gran_dillama_1080p.mp4
Start second: 32
Duration: 8 seconds
GIF width: 500px
Quality: 100.0%
Top text: What is
Bottom text: Gifcurry?

Writing temporary frames to... ./frames3617
Writing your GIF to... ./out.gif
Done.
```

## Dependencies

* [Haskell](https://www.haskell.org/platform/)
  * [System.IO.Temp (temporary)](https://hackage.haskell.org/package/temporary)
  * [Graphics.UI.Gtk (gtk)](https://hackage.haskell.org/package/gtk3-0.14.2)
* [FFmpeg](https://www.ffmpeg.org/download.html)
* [ImageMagick](http://www.imagemagick.org/script/download.php)
* [GTK+](http://www.gtk.org/download/index.php)

## Build & Run

```
git clone git@github.com:lettier/gifcurry.git
cd gifcurry/
cabal sandbox init
cabal install -j
./.cabal-sandbox/bin/gifcurry_gui
./.cabal-sandbox/bin/gifcurry_cli
```

## License

For license information, see [LICENSE](LICENSE).

_(C) 2016 David Lettier._  
http://www.lettier.com/
