#include <MacroPatternMatch.h>

#include "HROOTGrafTEllipse.h"
#include "TArc.h"
#include "HROOTGrafTArc.h"

using namespace std;


template<class ToType, class FromType>
const ToType* to_const(const FromType* x) {
  return reinterpret_cast<const ToType*>(x);
}

template<class ToType, class FromType>
ToType* to_nonconst(FromType* x) {
  return reinterpret_cast<ToType*>(x);
}

template<class ToType, class FromType>
const ToType& to_constref(const FromType& x) {
  return reinterpret_cast<const ToType&>(x);
}

template<class ToType, class FromType>
ToType& to_nonconstref(FromType& x) {
  return reinterpret_cast<ToType&>(x);
}


#define CHECKPROTECT(x,y) IS_PAREN(IS_ ## x ## _ ## y ## _PROTECTED)

#define TYPECASTMETHOD(cname,mname,oname) \
  IIF( CHECKPROTECT(cname,mname) ) ( \
  (to_nonconst<oname,cname ## _t>), \
  (to_nonconst<cname,cname ## _t>) )


TELLIPSE_DEF_VIRT(TArc)
TOBJECT_DEF_VIRT(TArc)
TATTLINE_DEF_VIRT(TArc)
TATTFILL_DEF_VIRT(TArc)
DELETABLE_DEF_VIRT(TArc)

TARC_DEF_VIRT(TArc)

TARC_DEF_NONVIRT(TArc)


