#include <MacroPatternMatch.h>

#include "HROOTCoreDeletable.h"
#include "TAttImage.h"
#include "HROOTGrafTAttImage.h"

using namespace std;


template<class ToType, class FromType>
const ToType* to_const(const FromType* x) {
  return reinterpret_cast<const ToType*>(x);
}

template<class ToType, class FromType>
ToType* to_nonconst(FromType* x) {
  return reinterpret_cast<ToType*>(x);
}

template<class ToType, class FromType>
const ToType& to_constref(const FromType& x) {
  return reinterpret_cast<const ToType&>(x);
}

template<class ToType, class FromType>
ToType& to_nonconstref(FromType& x) {
  return reinterpret_cast<ToType&>(x);
}


#define CHECKPROTECT(x,y) IS_PAREN(IS_ ## x ## _ ## y ## _PROTECTED)

#define TYPECASTMETHOD(cname,mname,oname) \
  IIF( CHECKPROTECT(cname,mname) ) ( \
  (to_nonconst<oname,cname ## _t>), \
  (to_nonconst<cname,cname ## _t>) )


DELETABLE_DEF_VIRT(TAttImage)

TATTIMAGE_DEF_VIRT(TAttImage)

TATTIMAGE_DEF_NONVIRT(TAttImage)


