#include <MacroPatternMatch.h>

#include "HROOTGrafTShape.h"
#include "TBRIK.h"
#include "HROOTGrafTBRIK.h"

using namespace std;


template<class ToType, class FromType>
const ToType* to_const(const FromType* x) {
  return reinterpret_cast<const ToType*>(x);
}

template<class ToType, class FromType>
ToType* to_nonconst(FromType* x) {
  return reinterpret_cast<ToType*>(x);
}

template<class ToType, class FromType>
const ToType& to_constref(const FromType& x) {
  return reinterpret_cast<const ToType&>(x);
}

template<class ToType, class FromType>
ToType& to_nonconstref(FromType& x) {
  return reinterpret_cast<ToType&>(x);
}


#define CHECKPROTECT(x,y) IS_PAREN(IS_ ## x ## _ ## y ## _PROTECTED)

#define TYPECASTMETHOD(cname,mname,oname) \
  IIF( CHECKPROTECT(cname,mname) ) ( \
  (to_nonconst<oname,cname ## _t>), \
  (to_nonconst<cname,cname ## _t>) )


TSHAPE_DEF_VIRT(TBRIK)
TNAMED_DEF_VIRT(TBRIK)
TATTLINE_DEF_VIRT(TBRIK)
TATTFILL_DEF_VIRT(TBRIK)
TATT3D_DEF_VIRT(TBRIK)
TOBJECT_DEF_VIRT(TBRIK)
DELETABLE_DEF_VIRT(TBRIK)

TBRIK_DEF_VIRT(TBRIK)

TBRIK_DEF_NONVIRT(TBRIK)


