#include <MacroPatternMatch.h>

#include "HROOTGrafTEllipse.h"
#include "TCrown.h"
#include "HROOTGrafTCrown.h"

using namespace std;


template<class ToType, class FromType>
const ToType* to_const(const FromType* x) {
  return reinterpret_cast<const ToType*>(x);
}

template<class ToType, class FromType>
ToType* to_nonconst(FromType* x) {
  return reinterpret_cast<ToType*>(x);
}

template<class ToType, class FromType>
const ToType& to_constref(const FromType& x) {
  return reinterpret_cast<const ToType&>(x);
}

template<class ToType, class FromType>
ToType& to_nonconstref(FromType& x) {
  return reinterpret_cast<ToType&>(x);
}


#define CHECKPROTECT(x,y) IS_PAREN(IS_ ## x ## _ ## y ## _PROTECTED)

#define TYPECASTMETHOD(cname,mname,oname) \
  IIF( CHECKPROTECT(cname,mname) ) ( \
  (to_nonconst<oname,cname ## _t>), \
  (to_nonconst<cname,cname ## _t>) )


TELLIPSE_DEF_VIRT(TCrown)
TOBJECT_DEF_VIRT(TCrown)
TATTLINE_DEF_VIRT(TCrown)
TATTFILL_DEF_VIRT(TCrown)
DELETABLE_DEF_VIRT(TCrown)

TCROWN_DEF_VIRT(TCrown)

TCROWN_DEF_NONVIRT(TCrown)


