#include <MacroPatternMatch.h>

#include "HROOTHistTGraph.h"
#include "TCutG.h"
#include "HROOTGrafTCutG.h"

using namespace std;


template<class ToType, class FromType>
const ToType* to_const(const FromType* x) {
  return reinterpret_cast<const ToType*>(x);
}

template<class ToType, class FromType>
ToType* to_nonconst(FromType* x) {
  return reinterpret_cast<ToType*>(x);
}

template<class ToType, class FromType>
const ToType& to_constref(const FromType& x) {
  return reinterpret_cast<const ToType&>(x);
}

template<class ToType, class FromType>
ToType& to_nonconstref(FromType& x) {
  return reinterpret_cast<ToType&>(x);
}


#define CHECKPROTECT(x,y) IS_PAREN(IS_ ## x ## _ ## y ## _PROTECTED)

#define TYPECASTMETHOD(cname,mname,oname) \
  IIF( CHECKPROTECT(cname,mname) ) ( \
  (to_nonconst<oname,cname ## _t>), \
  (to_nonconst<cname,cname ## _t>) )


TGRAPH_DEF_VIRT(TCutG)
TNAMED_DEF_VIRT(TCutG)
TATTLINE_DEF_VIRT(TCutG)
TATTFILL_DEF_VIRT(TCutG)
TATTMARKER_DEF_VIRT(TCutG)
TOBJECT_DEF_VIRT(TCutG)
DELETABLE_DEF_VIRT(TCutG)

TCUTG_DEF_VIRT(TCutG)

TCUTG_DEF_NONVIRT(TCutG)


