#include <MacroPatternMatch.h>

#include "HROOTGrafTLine.h"
#include "HROOTCoreTAttText.h"
#include "TGaxis.h"
#include "HROOTGrafTGaxis.h"

using namespace std;


template<class ToType, class FromType>
const ToType* to_const(const FromType* x) {
  return reinterpret_cast<const ToType*>(x);
}

template<class ToType, class FromType>
ToType* to_nonconst(FromType* x) {
  return reinterpret_cast<ToType*>(x);
}

template<class ToType, class FromType>
const ToType& to_constref(const FromType& x) {
  return reinterpret_cast<const ToType&>(x);
}

template<class ToType, class FromType>
ToType& to_nonconstref(FromType& x) {
  return reinterpret_cast<ToType&>(x);
}


#define CHECKPROTECT(x,y) IS_PAREN(IS_ ## x ## _ ## y ## _PROTECTED)

#define TYPECASTMETHOD(cname,mname,oname) \
  IIF( CHECKPROTECT(cname,mname) ) ( \
  (to_nonconst<oname,cname ## _t>), \
  (to_nonconst<cname,cname ## _t>) )


TLINE_DEF_VIRT(TGaxis)
TATTTEXT_DEF_VIRT(TGaxis)
TOBJECT_DEF_VIRT(TGaxis)
TATTLINE_DEF_VIRT(TGaxis)
DELETABLE_DEF_VIRT(TGaxis)

TGAXIS_DEF_VIRT(TGaxis)

TGAXIS_DEF_NONVIRT(TGaxis)


