#include <MacroPatternMatch.h>

#include "HROOTHistTGraphErrors.h"
#include "TGraphPolar.h"
#include "HROOTGrafTGraphPolar.h"

using namespace std;


template<class ToType, class FromType>
const ToType* to_const(const FromType* x) {
  return reinterpret_cast<const ToType*>(x);
}

template<class ToType, class FromType>
ToType* to_nonconst(FromType* x) {
  return reinterpret_cast<ToType*>(x);
}

template<class ToType, class FromType>
const ToType& to_constref(const FromType& x) {
  return reinterpret_cast<const ToType&>(x);
}

template<class ToType, class FromType>
ToType& to_nonconstref(FromType& x) {
  return reinterpret_cast<ToType&>(x);
}


#define CHECKPROTECT(x,y) IS_PAREN(IS_ ## x ## _ ## y ## _PROTECTED)

#define TYPECASTMETHOD(cname,mname,oname) \
  IIF( CHECKPROTECT(cname,mname) ) ( \
  (to_nonconst<oname,cname ## _t>), \
  (to_nonconst<cname,cname ## _t>) )


TGRAPHERRORS_DEF_VIRT(TGraphPolar)
TGRAPH_DEF_VIRT(TGraphPolar)
TNAMED_DEF_VIRT(TGraphPolar)
TATTLINE_DEF_VIRT(TGraphPolar)
TATTFILL_DEF_VIRT(TGraphPolar)
TATTMARKER_DEF_VIRT(TGraphPolar)
TOBJECT_DEF_VIRT(TGraphPolar)
DELETABLE_DEF_VIRT(TGraphPolar)

TGRAPHPOLAR_DEF_VIRT(TGraphPolar)

TGRAPHPOLAR_DEF_NONVIRT(TGraphPolar)


