#include <MacroPatternMatch.h>

#include "HROOTHistTGraph.h"
#include "TGraphQQ.h"
#include "HROOTGrafTGraphQQ.h"

using namespace std;


template<class ToType, class FromType>
const ToType* to_const(const FromType* x) {
  return reinterpret_cast<const ToType*>(x);
}

template<class ToType, class FromType>
ToType* to_nonconst(FromType* x) {
  return reinterpret_cast<ToType*>(x);
}

template<class ToType, class FromType>
const ToType& to_constref(const FromType& x) {
  return reinterpret_cast<const ToType&>(x);
}

template<class ToType, class FromType>
ToType& to_nonconstref(FromType& x) {
  return reinterpret_cast<ToType&>(x);
}


#define CHECKPROTECT(x,y) IS_PAREN(IS_ ## x ## _ ## y ## _PROTECTED)

#define TYPECASTMETHOD(cname,mname,oname) \
  IIF( CHECKPROTECT(cname,mname) ) ( \
  (to_nonconst<oname,cname ## _t>), \
  (to_nonconst<cname,cname ## _t>) )


TGRAPH_DEF_VIRT(TGraphQQ)
TNAMED_DEF_VIRT(TGraphQQ)
TATTLINE_DEF_VIRT(TGraphQQ)
TATTFILL_DEF_VIRT(TGraphQQ)
TATTMARKER_DEF_VIRT(TGraphQQ)
TOBJECT_DEF_VIRT(TGraphQQ)
DELETABLE_DEF_VIRT(TGraphQQ)

TGRAPHQQ_DEF_VIRT(TGraphQQ)

TGRAPHQQ_DEF_NONVIRT(TGraphQQ)


