#ifdef __cplusplus
extern "C" { 
#endif 

#ifndef __HROOT_GRAF__TLine__
#define __HROOT_GRAF__TLine__

#include "HROOT-grafType.h"

#include "HROOTCoreTObject.h"
#include "HROOTCoreTAttLine.h"
#include "HROOTCoreDeletable.h"
#include "HROOT-coreType.h"

#undef TLINE_DECL_VIRT
#define TLINE_DECL_VIRT(Type) \
TLine_p Type ## _DrawLine ( Type ## _p p, double x1, double y1, double x2, double y2 ); \
TLine_p Type ## _DrawLineNDC ( Type ## _p p, double x1, double y1, double x2, double y2 ); \
void Type ## _PaintLine ( Type ## _p p, double x1, double y1, double x2, double y2 ); \
void Type ## _PaintLineNDC ( Type ## _p p, double u1, double v1, double u2, double v2 ); \
void Type ## _SetX1 ( Type ## _p p, double x1 ); \
void Type ## _SetX2 ( Type ## _p p, double x2 ); \
void Type ## _SetY1 ( Type ## _p p, double y1 ); \
void Type ## _SetY2 ( Type ## _p p, double y2 )

#undef TLINE_DECL_NONVIRT
#define TLINE_DECL_NONVIRT(Type) \
Type ## _p Type ## _newTLine ( double x1, double y1, double x2, double y2 ); \
double Type ## _tLineGetX1 ( Type ## _p p ); \
double Type ## _tLineGetX2 ( Type ## _p p ); \
double Type ## _tLineGetY1 ( Type ## _p p ); \
double Type ## _tLineGetY2 ( Type ## _p p ); \
int Type ## _tLineIsHorizontal ( Type ## _p p ); \
int Type ## _tLineIsVertical ( Type ## _p p ); \
void Type ## _tLineSetHorizontal ( Type ## _p p, int set ); \
void Type ## _tLineSetVertical ( Type ## _p p, int set )

#undef TLINE_DEF_VIRT
#define TLINE_DEF_VIRT(Type)\
TLine_p Type ## _DrawLine ( Type ## _p p, double x1, double y1, double x2, double y2 )\
{\
return to_nonconst<TLine_t,TLine>((TLine*)TYPECASTMETHOD(Type,DrawLine,TLine)(p)->DrawLine(x1, y1, x2, y2));\
}\
TLine_p Type ## _DrawLineNDC ( Type ## _p p, double x1, double y1, double x2, double y2 )\
{\
return to_nonconst<TLine_t,TLine>((TLine*)TYPECASTMETHOD(Type,DrawLineNDC,TLine)(p)->DrawLineNDC(x1, y1, x2, y2));\
}\
void Type ## _PaintLine ( Type ## _p p, double x1, double y1, double x2, double y2 )\
{\
TYPECASTMETHOD(Type,PaintLine,TLine)(p)->PaintLine(x1, y1, x2, y2);\
}\
void Type ## _PaintLineNDC ( Type ## _p p, double u1, double v1, double u2, double v2 )\
{\
TYPECASTMETHOD(Type,PaintLineNDC,TLine)(p)->PaintLineNDC(u1, v1, u2, v2);\
}\
void Type ## _SetX1 ( Type ## _p p, double x1 )\
{\
TYPECASTMETHOD(Type,SetX1,TLine)(p)->SetX1(x1);\
}\
void Type ## _SetX2 ( Type ## _p p, double x2 )\
{\
TYPECASTMETHOD(Type,SetX2,TLine)(p)->SetX2(x2);\
}\
void Type ## _SetY1 ( Type ## _p p, double y1 )\
{\
TYPECASTMETHOD(Type,SetY1,TLine)(p)->SetY1(y1);\
}\
void Type ## _SetY2 ( Type ## _p p, double y2 )\
{\
TYPECASTMETHOD(Type,SetY2,TLine)(p)->SetY2(y2);\
}

#undef TLINE_DEF_NONVIRT
#define TLINE_DEF_NONVIRT(Type)\
Type ## _p Type ## _newTLine ( double x1, double y1, double x2, double y2 )\
{\
Type * newp = new Type (x1, y1, x2, y2); \
return to_nonconst<Type ## _t, Type >(newp);\
}\
double Type ## _tLineGetX1 ( Type ## _p p )\
{\
return TYPECASTMETHOD(Type,tLineGetX1,TLine)(p)->GetX1();\
}\
double Type ## _tLineGetX2 ( Type ## _p p )\
{\
return TYPECASTMETHOD(Type,tLineGetX2,TLine)(p)->GetX2();\
}\
double Type ## _tLineGetY1 ( Type ## _p p )\
{\
return TYPECASTMETHOD(Type,tLineGetY1,TLine)(p)->GetY1();\
}\
double Type ## _tLineGetY2 ( Type ## _p p )\
{\
return TYPECASTMETHOD(Type,tLineGetY2,TLine)(p)->GetY2();\
}\
int Type ## _tLineIsHorizontal ( Type ## _p p )\
{\
return TYPECASTMETHOD(Type,tLineIsHorizontal,TLine)(p)->IsHorizontal();\
}\
int Type ## _tLineIsVertical ( Type ## _p p )\
{\
return TYPECASTMETHOD(Type,tLineIsVertical,TLine)(p)->IsVertical();\
}\
void Type ## _tLineSetHorizontal ( Type ## _p p, int set )\
{\
TYPECASTMETHOD(Type,tLineSetHorizontal,TLine)(p)->SetHorizontal(set);\
}\
void Type ## _tLineSetVertical ( Type ## _p p, int set )\
{\
TYPECASTMETHOD(Type,tLineSetVertical,TLine)(p)->SetVertical(set);\
}

TOBJECT_DECL_VIRT(TLine);
TATTLINE_DECL_VIRT(TLine);
DELETABLE_DECL_VIRT(TLine);


TLINE_DECL_VIRT(TLine);


TLINE_DECL_NONVIRT(TLine);


#endif // __HROOT_GRAF__TLine__

#ifdef __cplusplus
}
#endif
