#include <MacroPatternMatch.h>

#include "HROOTGrafTShape.h"
#include "TPCON.h"
#include "HROOTGrafTPCON.h"

using namespace std;


template<class ToType, class FromType>
const ToType* to_const(const FromType* x) {
  return reinterpret_cast<const ToType*>(x);
}

template<class ToType, class FromType>
ToType* to_nonconst(FromType* x) {
  return reinterpret_cast<ToType*>(x);
}

template<class ToType, class FromType>
const ToType& to_constref(const FromType& x) {
  return reinterpret_cast<const ToType&>(x);
}

template<class ToType, class FromType>
ToType& to_nonconstref(FromType& x) {
  return reinterpret_cast<ToType&>(x);
}


#define CHECKPROTECT(x,y) IS_PAREN(IS_ ## x ## _ ## y ## _PROTECTED)

#define TYPECASTMETHOD(cname,mname,oname) \
  IIF( CHECKPROTECT(cname,mname) ) ( \
  (to_nonconst<oname,cname ## _t>), \
  (to_nonconst<cname,cname ## _t>) )


TSHAPE_DEF_VIRT(TPCON)
TNAMED_DEF_VIRT(TPCON)
TATTLINE_DEF_VIRT(TPCON)
TATTFILL_DEF_VIRT(TPCON)
TATT3D_DEF_VIRT(TPCON)
TOBJECT_DEF_VIRT(TPCON)
DELETABLE_DEF_VIRT(TPCON)

TPCON_DEF_VIRT(TPCON)

TPCON_DEF_NONVIRT(TPCON)


