#include <MacroPatternMatch.h>

#include "HROOTGrafTShape.h"
#include "TSPHE.h"
#include "HROOTGrafTSPHE.h"

using namespace std;


template<class ToType, class FromType>
const ToType* to_const(const FromType* x) {
  return reinterpret_cast<const ToType*>(x);
}

template<class ToType, class FromType>
ToType* to_nonconst(FromType* x) {
  return reinterpret_cast<ToType*>(x);
}

template<class ToType, class FromType>
const ToType& to_constref(const FromType& x) {
  return reinterpret_cast<const ToType&>(x);
}

template<class ToType, class FromType>
ToType& to_nonconstref(FromType& x) {
  return reinterpret_cast<ToType&>(x);
}


#define CHECKPROTECT(x,y) IS_PAREN(IS_ ## x ## _ ## y ## _PROTECTED)

#define TYPECASTMETHOD(cname,mname,oname) \
  IIF( CHECKPROTECT(cname,mname) ) ( \
  (to_nonconst<oname,cname ## _t>), \
  (to_nonconst<cname,cname ## _t>) )


TSHAPE_DEF_VIRT(TSPHE)
TNAMED_DEF_VIRT(TSPHE)
TATTLINE_DEF_VIRT(TSPHE)
TATTFILL_DEF_VIRT(TSPHE)
TATT3D_DEF_VIRT(TSPHE)
TOBJECT_DEF_VIRT(TSPHE)
DELETABLE_DEF_VIRT(TSPHE)

TSPHE_DEF_VIRT(TSPHE)

TSPHE_DEF_NONVIRT(TSPHE)


