#include <MacroPatternMatch.h>

#include "HROOTCoreTNamed.h"
#include "HROOTCoreTAttLine.h"
#include "HROOTCoreTAttFill.h"
#include "HROOTCoreTAtt3D.h"
#include "TShape.h"
#include "HROOTGrafTShape.h"

using namespace std;


template<class ToType, class FromType>
const ToType* to_const(const FromType* x) {
  return reinterpret_cast<const ToType*>(x);
}

template<class ToType, class FromType>
ToType* to_nonconst(FromType* x) {
  return reinterpret_cast<ToType*>(x);
}

template<class ToType, class FromType>
const ToType& to_constref(const FromType& x) {
  return reinterpret_cast<const ToType&>(x);
}

template<class ToType, class FromType>
ToType& to_nonconstref(FromType& x) {
  return reinterpret_cast<ToType&>(x);
}


#define CHECKPROTECT(x,y) IS_PAREN(IS_ ## x ## _ ## y ## _PROTECTED)

#define TYPECASTMETHOD(cname,mname,oname) \
  IIF( CHECKPROTECT(cname,mname) ) ( \
  (to_nonconst<oname,cname ## _t>), \
  (to_nonconst<cname,cname ## _t>) )


TNAMED_DEF_VIRT(TShape)
TATTLINE_DEF_VIRT(TShape)
TATTFILL_DEF_VIRT(TShape)
TATT3D_DEF_VIRT(TShape)
TOBJECT_DEF_VIRT(TShape)
DELETABLE_DEF_VIRT(TShape)

TSHAPE_DEF_VIRT(TShape)

TSHAPE_DEF_NONVIRT(TShape)


