#include <MacroPatternMatch.h>

#include "HROOTGrafTShape.h"
#include "TTUBE.h"
#include "HROOTGrafTTUBE.h"

using namespace std;


template<class ToType, class FromType>
const ToType* to_const(const FromType* x) {
  return reinterpret_cast<const ToType*>(x);
}

template<class ToType, class FromType>
ToType* to_nonconst(FromType* x) {
  return reinterpret_cast<ToType*>(x);
}

template<class ToType, class FromType>
const ToType& to_constref(const FromType& x) {
  return reinterpret_cast<const ToType&>(x);
}

template<class ToType, class FromType>
ToType& to_nonconstref(FromType& x) {
  return reinterpret_cast<ToType&>(x);
}


#define CHECKPROTECT(x,y) IS_PAREN(IS_ ## x ## _ ## y ## _PROTECTED)

#define TYPECASTMETHOD(cname,mname,oname) \
  IIF( CHECKPROTECT(cname,mname) ) ( \
  (to_nonconst<oname,cname ## _t>), \
  (to_nonconst<cname,cname ## _t>) )


TSHAPE_DEF_VIRT(TTUBE)
TNAMED_DEF_VIRT(TTUBE)
TATTLINE_DEF_VIRT(TTUBE)
TATTFILL_DEF_VIRT(TTUBE)
TATT3D_DEF_VIRT(TTUBE)
TOBJECT_DEF_VIRT(TTUBE)
DELETABLE_DEF_VIRT(TTUBE)

TTUBE_DEF_VIRT(TTUBE)

TTUBE_DEF_NONVIRT(TTUBE)


