{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, EmptyDataDecls, 
             OverlappingInstances, IncoherentInstances #-}

module HROOT.Graf.TArc.Implementation where


import FFICXX.Runtime.Cast

import HROOT.Graf.TArc.RawType
import HROOT.Graf.TArc.FFI
import HROOT.Graf.TArc.Interface
import HROOT.Graf.TArc.Cast
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Graf.TEllipse.RawType
import HROOT.Graf.TEllipse.Cast
import HROOT.Graf.TEllipse.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import HROOT.Core.TAttLine.RawType
import HROOT.Core.TAttLine.Cast
import HROOT.Core.TAttLine.Interface
import HROOT.Core.TAttFill.RawType
import HROOT.Core.TAttFill.Cast
import HROOT.Core.TAttFill.Interface
import HROOT.Core.Deletable.RawType
import HROOT.Core.Deletable.Cast
import HROOT.Core.Deletable.Interface

import Data.Word
import Foreign.C
import Foreign.Ptr 
import Foreign.ForeignPtr

import System.IO.Unsafe


instance ITArc TArc where
instance ITEllipse TArc where
instance ITObject TArc where
  draw = xform1 c_tarc_draw
  findObject = xform1 c_tarc_findobject
  getName = xform0 c_tarc_getname
  isA = xform0 c_tarc_isa
  paint = xform1 c_tarc_paint
  printObj = xform1 c_tarc_printobj
  saveAs = xform2 c_tarc_saveas
  write = xform3 c_tarc_write
instance ITAttLine TArc where
  getLineColor = xform0 c_tarc_getlinecolor
  getLineStyle = xform0 c_tarc_getlinestyle
  getLineWidth = xform0 c_tarc_getlinewidth
  resetAttLine = xform1 c_tarc_resetattline
  setLineAttributes = xform0 c_tarc_setlineattributes
  setLineColor = xform1 c_tarc_setlinecolor
  setLineStyle = xform1 c_tarc_setlinestyle
  setLineWidth = xform1 c_tarc_setlinewidth
instance ITAttFill TArc where
  setFillColor = xform1 c_tarc_setfillcolor
  setFillStyle = xform1 c_tarc_setfillstyle
instance IDeletable TArc where
  delete = xform0 c_tarc_delete

instance ITArc (Exist TArc) where

instance ITEllipse (Exist TArc) where

instance ITObject (Exist TArc) where
  draw (ETArc x) = draw x
  findObject (ETArc x) = findObject x
  getName (ETArc x) = getName x
  isA (ETArc x) = isA x
  paint (ETArc x) = paint x
  printObj (ETArc x) = printObj x
  saveAs (ETArc x) = saveAs x
  write (ETArc x) = write x
instance ITAttLine (Exist TArc) where
  getLineColor (ETArc x) = getLineColor x
  getLineStyle (ETArc x) = getLineStyle x
  getLineWidth (ETArc x) = getLineWidth x
  resetAttLine (ETArc x) = resetAttLine x
  setLineAttributes (ETArc x) = setLineAttributes x
  setLineColor (ETArc x) = setLineColor x
  setLineStyle (ETArc x) = setLineStyle x
  setLineWidth (ETArc x) = setLineWidth x
instance ITAttFill (Exist TArc) where
  setFillColor (ETArc x) = setFillColor x
  setFillStyle (ETArc x) = setFillStyle x
instance IDeletable (Exist TArc) where
  delete (ETArc x) = delete x


newTArc :: CDouble -> CDouble -> CDouble -> CDouble -> CDouble -> IO TArc
newTArc = xform4 c_tarc_newtarc





instance FPtr (Exist TArc) where
  type Raw (Exist TArc) = RawTArc
  get_fptr (ETArc obj) = castForeignPtr (get_fptr obj)
  cast_fptr_to_obj fptr = ETArc (cast_fptr_to_obj (fptr :: ForeignPtr RawTArc) :: TArc)
