{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, 
             EmptyDataDecls, ExistentialQuantification, ScopedTypeVariables #-}

-- module HROOT.Class.Interface where

module HROOT.Graf.TArc.Interface where


import Data.Word
import Foreign.C
import Foreign.Ptr
import Foreign.ForeignPtr
import FFICXX.Runtime.Cast

import HROOT.Graf.TArc.RawType

import HROOT.Graf.TEllipse.Interface
---- ============ ----



class (ITEllipse a) => ITArc a where

instance Existable TArc where
  data Exist TArc = forall a. (FPtr a, ITArc a) => ETArc a

upcastTArc :: (FPtr a, ITArc a) => a -> TArc
upcastTArc h = let fh = get_fptr h
                   fh2 :: ForeignPtr RawTArc = castForeignPtr fh
               in cast_fptr_to_obj fh2

downcastTArc :: (FPtr a, ITArc a) => TArc -> a 
downcastTArc h = let fh = get_fptr h
                     fh2 = castForeignPtr fh
                 in cast_fptr_to_obj fh2
