{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, EmptyDataDecls, 
             OverlappingInstances, IncoherentInstances #-}

module HROOT.Graf.TArrow.Implementation where


import FFICXX.Runtime.Cast

import HROOT.Graf.TArrow.RawType
import HROOT.Graf.TArrow.FFI
import HROOT.Graf.TArrow.Interface
import HROOT.Graf.TArrow.Cast
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Graf.TLine.RawType
import HROOT.Graf.TLine.Cast
import HROOT.Graf.TLine.Interface
import HROOT.Core.TAttFill.RawType
import HROOT.Core.TAttFill.Cast
import HROOT.Core.TAttFill.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import HROOT.Core.TAttLine.RawType
import HROOT.Core.TAttLine.Cast
import HROOT.Core.TAttLine.Interface
import HROOT.Core.Deletable.RawType
import HROOT.Core.Deletable.Cast
import HROOT.Core.Deletable.Interface

import Data.Word
import Foreign.C
import Foreign.Ptr 
import Foreign.ForeignPtr

import System.IO.Unsafe


instance ITArrow TArrow where
instance ITLine TArrow where
  drawLine = xform4 c_tarrow_drawline
  drawLineNDC = xform4 c_tarrow_drawlinendc
  paintLine = xform4 c_tarrow_paintline
  paintLineNDC = xform4 c_tarrow_paintlinendc
  setX1 = xform1 c_tarrow_setx1
  setX2 = xform1 c_tarrow_setx2
  setY1 = xform1 c_tarrow_sety1
  setY2 = xform1 c_tarrow_sety2
instance ITAttFill TArrow where
  setFillColor = xform1 c_tarrow_setfillcolor
  setFillStyle = xform1 c_tarrow_setfillstyle
instance ITObject TArrow where
  draw = xform1 c_tarrow_draw
  findObject = xform1 c_tarrow_findobject
  getName = xform0 c_tarrow_getname
  isA = xform0 c_tarrow_isa
  paint = xform1 c_tarrow_paint
  printObj = xform1 c_tarrow_printobj
  saveAs = xform2 c_tarrow_saveas
  write = xform3 c_tarrow_write
instance ITAttLine TArrow where
  getLineColor = xform0 c_tarrow_getlinecolor
  getLineStyle = xform0 c_tarrow_getlinestyle
  getLineWidth = xform0 c_tarrow_getlinewidth
  resetAttLine = xform1 c_tarrow_resetattline
  setLineAttributes = xform0 c_tarrow_setlineattributes
  setLineColor = xform1 c_tarrow_setlinecolor
  setLineStyle = xform1 c_tarrow_setlinestyle
  setLineWidth = xform1 c_tarrow_setlinewidth
instance IDeletable TArrow where
  delete = xform0 c_tarrow_delete

instance ITArrow (Exist TArrow) where

instance ITLine (Exist TArrow) where
  drawLine (ETArrow x) = drawLine x
  drawLineNDC (ETArrow x) = drawLineNDC x
  paintLine (ETArrow x) = paintLine x
  paintLineNDC (ETArrow x) = paintLineNDC x
  setX1 (ETArrow x) = setX1 x
  setX2 (ETArrow x) = setX2 x
  setY1 (ETArrow x) = setY1 x
  setY2 (ETArrow x) = setY2 x
instance ITAttFill (Exist TArrow) where
  setFillColor (ETArrow x) = setFillColor x
  setFillStyle (ETArrow x) = setFillStyle x
instance ITObject (Exist TArrow) where
  draw (ETArrow x) = draw x
  findObject (ETArrow x) = findObject x
  getName (ETArrow x) = getName x
  isA (ETArrow x) = isA x
  paint (ETArrow x) = paint x
  printObj (ETArrow x) = printObj x
  saveAs (ETArrow x) = saveAs x
  write (ETArrow x) = write x
instance ITAttLine (Exist TArrow) where
  getLineColor (ETArrow x) = getLineColor x
  getLineStyle (ETArrow x) = getLineStyle x
  getLineWidth (ETArrow x) = getLineWidth x
  resetAttLine (ETArrow x) = resetAttLine x
  setLineAttributes (ETArrow x) = setLineAttributes x
  setLineColor (ETArrow x) = setLineColor x
  setLineStyle (ETArrow x) = setLineStyle x
  setLineWidth (ETArrow x) = setLineWidth x
instance IDeletable (Exist TArrow) where
  delete (ETArrow x) = delete x


newTArrow :: CDouble -> CDouble -> CDouble -> CDouble -> CDouble -> CString -> IO TArrow
newTArrow = xform5 c_tarrow_newtarrow





instance FPtr (Exist TArrow) where
  type Raw (Exist TArrow) = RawTArrow
  get_fptr (ETArrow obj) = castForeignPtr (get_fptr obj)
  cast_fptr_to_obj fptr = ETArrow (cast_fptr_to_obj (fptr :: ForeignPtr RawTArrow) :: TArrow)
