{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, 
             EmptyDataDecls, ExistentialQuantification, ScopedTypeVariables #-}

-- module HROOT.Class.Interface where

module HROOT.Graf.TArrow.Interface where


import Data.Word
import Foreign.C
import Foreign.Ptr
import Foreign.ForeignPtr
import FFICXX.Runtime.Cast

import HROOT.Graf.TArrow.RawType

import HROOT.Graf.TLine.Interface
import HROOT.Core.TAttFill.Interface
---- ============ ----



class (ITLine a,ITAttFill a) => ITArrow a where

instance Existable TArrow where
  data Exist TArrow = forall a. (FPtr a, ITArrow a) => ETArrow a

upcastTArrow :: (FPtr a, ITArrow a) => a -> TArrow
upcastTArrow h = let fh = get_fptr h
                     fh2 :: ForeignPtr RawTArrow = castForeignPtr fh
                 in cast_fptr_to_obj fh2

downcastTArrow :: (FPtr a, ITArrow a) => TArrow -> a 
downcastTArrow h = let fh = get_fptr h
                       fh2 = castForeignPtr fh
                   in cast_fptr_to_obj fh2
