{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, 
             EmptyDataDecls, ExistentialQuantification, ScopedTypeVariables #-}

-- module HROOT.Class.Interface where

module HROOT.Graf.TAttImage.Interface where


import Data.Word
import Foreign.C
import Foreign.Ptr
import Foreign.ForeignPtr
import FFICXX.Runtime.Cast

import HROOT.Graf.TAttImage.RawType

import HROOT.Core.Deletable.Interface
---- ============ ----



class (IDeletable a) => ITAttImage a where

instance Existable TAttImage where
  data Exist TAttImage = forall a. (FPtr a, ITAttImage a) => ETAttImage a

upcastTAttImage :: (FPtr a, ITAttImage a) => a -> TAttImage
upcastTAttImage h = let fh = get_fptr h
                        fh2 :: ForeignPtr RawTAttImage = castForeignPtr fh
                    in cast_fptr_to_obj fh2

downcastTAttImage :: (FPtr a, ITAttImage a) => TAttImage -> a 
downcastTAttImage h = let fh = get_fptr h
                          fh2 = castForeignPtr fh
                      in cast_fptr_to_obj fh2
