{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, EmptyDataDecls, 
             OverlappingInstances, IncoherentInstances #-}

module HROOT.Graf.TBRIK.Implementation where


import FFICXX.Runtime.Cast

import HROOT.Graf.TBRIK.RawType
import HROOT.Graf.TBRIK.FFI
import HROOT.Graf.TBRIK.Interface
import HROOT.Graf.TBRIK.Cast
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Graf.TShape.RawType
import HROOT.Graf.TShape.Cast
import HROOT.Graf.TShape.Interface
import HROOT.Core.TNamed.RawType
import HROOT.Core.TNamed.Cast
import HROOT.Core.TNamed.Interface
import HROOT.Core.TAttLine.RawType
import HROOT.Core.TAttLine.Cast
import HROOT.Core.TAttLine.Interface
import HROOT.Core.TAttFill.RawType
import HROOT.Core.TAttFill.Cast
import HROOT.Core.TAttFill.Interface
import HROOT.Core.TAtt3D.RawType
import HROOT.Core.TAtt3D.Cast
import HROOT.Core.TAtt3D.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import HROOT.Core.Deletable.RawType
import HROOT.Core.Deletable.Cast
import HROOT.Core.Deletable.Interface

import Data.Word
import Foreign.C
import Foreign.Ptr 
import Foreign.ForeignPtr

import System.IO.Unsafe


instance ITBRIK TBRIK where
instance ITShape TBRIK where
instance ITNamed TBRIK where
  setName = xform1 c_tbrik_setname
  setNameTitle = xform2 c_tbrik_setnametitle
  setTitle = xform1 c_tbrik_settitle
instance ITAttLine TBRIK where
  getLineColor = xform0 c_tbrik_getlinecolor
  getLineStyle = xform0 c_tbrik_getlinestyle
  getLineWidth = xform0 c_tbrik_getlinewidth
  resetAttLine = xform1 c_tbrik_resetattline
  setLineAttributes = xform0 c_tbrik_setlineattributes
  setLineColor = xform1 c_tbrik_setlinecolor
  setLineStyle = xform1 c_tbrik_setlinestyle
  setLineWidth = xform1 c_tbrik_setlinewidth
instance ITAttFill TBRIK where
  setFillColor = xform1 c_tbrik_setfillcolor
  setFillStyle = xform1 c_tbrik_setfillstyle
instance ITAtt3D TBRIK where
instance ITObject TBRIK where
  draw = xform1 c_tbrik_draw
  findObject = xform1 c_tbrik_findobject
  getName = xform0 c_tbrik_getname
  isA = xform0 c_tbrik_isa
  paint = xform1 c_tbrik_paint
  printObj = xform1 c_tbrik_printobj
  saveAs = xform2 c_tbrik_saveas
  write = xform3 c_tbrik_write
instance IDeletable TBRIK where
  delete = xform0 c_tbrik_delete

instance ITBRIK (Exist TBRIK) where

instance ITShape (Exist TBRIK) where

instance ITNamed (Exist TBRIK) where
  setName (ETBRIK x) = setName x
  setNameTitle (ETBRIK x) = setNameTitle x
  setTitle (ETBRIK x) = setTitle x
instance ITAttLine (Exist TBRIK) where
  getLineColor (ETBRIK x) = getLineColor x
  getLineStyle (ETBRIK x) = getLineStyle x
  getLineWidth (ETBRIK x) = getLineWidth x
  resetAttLine (ETBRIK x) = resetAttLine x
  setLineAttributes (ETBRIK x) = setLineAttributes x
  setLineColor (ETBRIK x) = setLineColor x
  setLineStyle (ETBRIK x) = setLineStyle x
  setLineWidth (ETBRIK x) = setLineWidth x
instance ITAttFill (Exist TBRIK) where
  setFillColor (ETBRIK x) = setFillColor x
  setFillStyle (ETBRIK x) = setFillStyle x
instance ITAtt3D (Exist TBRIK) where

instance ITObject (Exist TBRIK) where
  draw (ETBRIK x) = draw x
  findObject (ETBRIK x) = findObject x
  getName (ETBRIK x) = getName x
  isA (ETBRIK x) = isA x
  paint (ETBRIK x) = paint x
  printObj (ETBRIK x) = printObj x
  saveAs (ETBRIK x) = saveAs x
  write (ETBRIK x) = write x
instance IDeletable (Exist TBRIK) where
  delete (ETBRIK x) = delete x


newTBRIK :: CString -> CString -> CString -> CDouble -> CDouble -> CDouble -> IO TBRIK
newTBRIK = xform5 c_tbrik_newtbrik





instance FPtr (Exist TBRIK) where
  type Raw (Exist TBRIK) = RawTBRIK
  get_fptr (ETBRIK obj) = castForeignPtr (get_fptr obj)
  cast_fptr_to_obj fptr = ETBRIK (cast_fptr_to_obj (fptr :: ForeignPtr RawTBRIK) :: TBRIK)
