{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, EmptyDataDecls, 
             OverlappingInstances, IncoherentInstances #-}

module HROOT.Graf.TCanvas.Implementation where


import FFICXX.Runtime.Cast

import HROOT.Graf.TCanvas.RawType
import HROOT.Graf.TCanvas.FFI
import HROOT.Graf.TCanvas.Interface
import HROOT.Graf.TCanvas.Cast
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Graf.TPad.RawType
import HROOT.Graf.TPad.Cast
import HROOT.Graf.TPad.Interface
import HROOT.Core.TVirtualPad.RawType
import HROOT.Core.TVirtualPad.Cast
import HROOT.Core.TVirtualPad.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import HROOT.Core.Deletable.RawType
import HROOT.Core.Deletable.Cast
import HROOT.Core.Deletable.Interface

import Data.Word
import Foreign.C
import Foreign.Ptr 
import Foreign.ForeignPtr

import System.IO.Unsafe


instance ITCanvas TCanvas where
instance ITPad TCanvas where
instance ITVirtualPad TCanvas where
  cd = xform1 c_tcanvas_cd
  divide_tvirtualpad = xform5 c_tcanvas_divide_tvirtualpad
  setLogx = xform1 c_tcanvas_setlogx
  setLogy = xform1 c_tcanvas_setlogy
  setLogz = xform1 c_tcanvas_setlogz
instance ITObject TCanvas where
  draw = xform1 c_tcanvas_draw
  findObject = xform1 c_tcanvas_findobject
  getName = xform0 c_tcanvas_getname
  isA = xform0 c_tcanvas_isa
  paint = xform1 c_tcanvas_paint
  printObj = xform1 c_tcanvas_printobj
  saveAs = xform2 c_tcanvas_saveas
  write = xform3 c_tcanvas_write
instance IDeletable TCanvas where
  delete = xform0 c_tcanvas_delete

instance ITCanvas (Exist TCanvas) where

instance ITPad (Exist TCanvas) where

instance ITVirtualPad (Exist TCanvas) where
  cd (ETCanvas x) a1 = return . ETCanvas =<< cd x a1
  divide_tvirtualpad (ETCanvas x) = divide_tvirtualpad x
  setLogx (ETCanvas x) = setLogx x
  setLogy (ETCanvas x) = setLogy x
  setLogz (ETCanvas x) = setLogz x
instance ITObject (Exist TCanvas) where
  draw (ETCanvas x) = draw x
  findObject (ETCanvas x) = findObject x
  getName (ETCanvas x) = getName x
  isA (ETCanvas x) = isA x
  paint (ETCanvas x) = paint x
  printObj (ETCanvas x) = printObj x
  saveAs (ETCanvas x) = saveAs x
  write (ETCanvas x) = write x
instance IDeletable (Exist TCanvas) where
  delete (ETCanvas x) = delete x


newTCanvas :: CString -> CString -> CInt -> CInt -> IO TCanvas
newTCanvas = xform3 c_tcanvas_newtcanvas





instance FPtr (Exist TCanvas) where
  type Raw (Exist TCanvas) = RawTCanvas
  get_fptr (ETCanvas obj) = castForeignPtr (get_fptr obj)
  cast_fptr_to_obj fptr = ETCanvas (cast_fptr_to_obj (fptr :: ForeignPtr RawTCanvas) :: TCanvas)
