{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, 
             EmptyDataDecls, ExistentialQuantification, ScopedTypeVariables #-}

-- module HROOT.Class.Interface where

module HROOT.Graf.TCanvas.Interface where


import Data.Word
import Foreign.C
import Foreign.Ptr
import Foreign.ForeignPtr
import FFICXX.Runtime.Cast

import HROOT.Graf.TCanvas.RawType

import HROOT.Graf.TPad.Interface
---- ============ ----



class (ITPad a) => ITCanvas a where

instance Existable TCanvas where
  data Exist TCanvas = forall a. (FPtr a, ITCanvas a) => ETCanvas a

upcastTCanvas :: (FPtr a, ITCanvas a) => a -> TCanvas
upcastTCanvas h = let fh = get_fptr h
                      fh2 :: ForeignPtr RawTCanvas = castForeignPtr fh
                  in cast_fptr_to_obj fh2

downcastTCanvas :: (FPtr a, ITCanvas a) => TCanvas -> a 
downcastTCanvas h = let fh = get_fptr h
                        fh2 = castForeignPtr fh
                    in cast_fptr_to_obj fh2
