{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, EmptyDataDecls, 
             OverlappingInstances, IncoherentInstances #-}

module HROOT.Graf.TCrown.Implementation where


import FFICXX.Runtime.Cast

import HROOT.Graf.TCrown.RawType
import HROOT.Graf.TCrown.FFI
import HROOT.Graf.TCrown.Interface
import HROOT.Graf.TCrown.Cast
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Graf.TEllipse.RawType
import HROOT.Graf.TEllipse.Cast
import HROOT.Graf.TEllipse.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import HROOT.Core.TAttLine.RawType
import HROOT.Core.TAttLine.Cast
import HROOT.Core.TAttLine.Interface
import HROOT.Core.TAttFill.RawType
import HROOT.Core.TAttFill.Cast
import HROOT.Core.TAttFill.Interface
import HROOT.Core.Deletable.RawType
import HROOT.Core.Deletable.Cast
import HROOT.Core.Deletable.Interface

import Data.Word
import Foreign.C
import Foreign.Ptr 
import Foreign.ForeignPtr

import System.IO.Unsafe


instance ITCrown TCrown where
instance ITEllipse TCrown where
instance ITObject TCrown where
  draw = xform1 c_tcrown_draw
  findObject = xform1 c_tcrown_findobject
  getName = xform0 c_tcrown_getname
  isA = xform0 c_tcrown_isa
  paint = xform1 c_tcrown_paint
  printObj = xform1 c_tcrown_printobj
  saveAs = xform2 c_tcrown_saveas
  write = xform3 c_tcrown_write
instance ITAttLine TCrown where
  getLineColor = xform0 c_tcrown_getlinecolor
  getLineStyle = xform0 c_tcrown_getlinestyle
  getLineWidth = xform0 c_tcrown_getlinewidth
  resetAttLine = xform1 c_tcrown_resetattline
  setLineAttributes = xform0 c_tcrown_setlineattributes
  setLineColor = xform1 c_tcrown_setlinecolor
  setLineStyle = xform1 c_tcrown_setlinestyle
  setLineWidth = xform1 c_tcrown_setlinewidth
instance ITAttFill TCrown where
  setFillColor = xform1 c_tcrown_setfillcolor
  setFillStyle = xform1 c_tcrown_setfillstyle
instance IDeletable TCrown where
  delete = xform0 c_tcrown_delete

instance ITCrown (Exist TCrown) where

instance ITEllipse (Exist TCrown) where

instance ITObject (Exist TCrown) where
  draw (ETCrown x) = draw x
  findObject (ETCrown x) = findObject x
  getName (ETCrown x) = getName x
  isA (ETCrown x) = isA x
  paint (ETCrown x) = paint x
  printObj (ETCrown x) = printObj x
  saveAs (ETCrown x) = saveAs x
  write (ETCrown x) = write x
instance ITAttLine (Exist TCrown) where
  getLineColor (ETCrown x) = getLineColor x
  getLineStyle (ETCrown x) = getLineStyle x
  getLineWidth (ETCrown x) = getLineWidth x
  resetAttLine (ETCrown x) = resetAttLine x
  setLineAttributes (ETCrown x) = setLineAttributes x
  setLineColor (ETCrown x) = setLineColor x
  setLineStyle (ETCrown x) = setLineStyle x
  setLineWidth (ETCrown x) = setLineWidth x
instance ITAttFill (Exist TCrown) where
  setFillColor (ETCrown x) = setFillColor x
  setFillStyle (ETCrown x) = setFillStyle x
instance IDeletable (Exist TCrown) where
  delete (ETCrown x) = delete x


newTCrown :: CDouble -> CDouble -> CDouble -> CDouble -> CDouble -> CDouble -> IO TCrown
newTCrown = xform5 c_tcrown_newtcrown





instance FPtr (Exist TCrown) where
  type Raw (Exist TCrown) = RawTCrown
  get_fptr (ETCrown obj) = castForeignPtr (get_fptr obj)
  cast_fptr_to_obj fptr = ETCrown (cast_fptr_to_obj (fptr :: ForeignPtr RawTCrown) :: TCrown)
