{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, EmptyDataDecls, 
             OverlappingInstances, IncoherentInstances #-}

module HROOT.Graf.TCutG.Implementation where


import FFICXX.Runtime.Cast

import HROOT.Graf.TCutG.RawType
import HROOT.Graf.TCutG.FFI
import HROOT.Graf.TCutG.Interface
import HROOT.Graf.TCutG.Cast
import HROOT.Hist.TF1.RawType
import HROOT.Hist.TF1.Cast
import HROOT.Hist.TF1.Interface
import HROOT.Hist.TH1F.RawType
import HROOT.Hist.TH1F.Cast
import HROOT.Hist.TH1F.Interface
import HROOT.Hist.TAxis.RawType
import HROOT.Hist.TAxis.Cast
import HROOT.Hist.TAxis.Interface
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Hist.TGraph.RawType
import HROOT.Hist.TGraph.Cast
import HROOT.Hist.TGraph.Interface
import HROOT.Core.TNamed.RawType
import HROOT.Core.TNamed.Cast
import HROOT.Core.TNamed.Interface
import HROOT.Core.TAttLine.RawType
import HROOT.Core.TAttLine.Cast
import HROOT.Core.TAttLine.Interface
import HROOT.Core.TAttFill.RawType
import HROOT.Core.TAttFill.Cast
import HROOT.Core.TAttFill.Interface
import HROOT.Core.TAttMarker.RawType
import HROOT.Core.TAttMarker.Cast
import HROOT.Core.TAttMarker.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import HROOT.Core.Deletable.RawType
import HROOT.Core.Deletable.Cast
import HROOT.Core.Deletable.Interface

import Data.Word
import Foreign.C
import Foreign.Ptr 
import Foreign.ForeignPtr

import System.IO.Unsafe


instance ITCutG TCutG where
instance ITGraph TCutG where
  apply = xform1 c_tcutg_apply
  chisquare = xform1 c_tcutg_chisquare
  drawGraph = xform4 c_tcutg_drawgraph
  drawPanelTGraph = xform0 c_tcutg_drawpaneltgraph
  expand = xform2 c_tcutg_expand
  fitPanelTGraph = xform0 c_tcutg_fitpaneltgraph
  getCorrelationFactorTGraph = xform0 c_tcutg_getcorrelationfactortgraph
  getCovarianceTGraph = xform0 c_tcutg_getcovariancetgraph
  getMeanTGraph = xform1 c_tcutg_getmeantgraph
  getRMSTGraph = xform1 c_tcutg_getrmstgraph
  getErrorX = xform1 c_tcutg_geterrorx
  getErrorY = xform1 c_tcutg_geterrory
  getErrorXhigh = xform1 c_tcutg_geterrorxhigh
  getErrorXlow = xform1 c_tcutg_geterrorxlow
  getErrorYhigh = xform1 c_tcutg_geterroryhigh
  getErrorYlow = xform1 c_tcutg_geterrorylow
  initExpo = xform2 c_tcutg_initexpo
  initGaus = xform2 c_tcutg_initgaus
  initPolynom = xform2 c_tcutg_initpolynom
  insertPoint = xform0 c_tcutg_insertpoint
  integralTGraph = xform2 c_tcutg_integraltgraph
  isEditable = xform0 c_tcutg_iseditable
  isInsideTGraph = xform2 c_tcutg_isinsidetgraph
  leastSquareFit = xform4 c_tcutg_leastsquarefit
  paintStats = xform1 c_tcutg_paintstats
  removePoint = xform1 c_tcutg_removepoint
  setEditable = xform1 c_tcutg_seteditable
  setHistogram = xform1 c_tcutg_sethistogram
  setMaximumTGraph = xform1 c_tcutg_setmaximumtgraph
  setMinimumTGraph = xform1 c_tcutg_setminimumtgraph
  set = xform1 c_tcutg_set
  setPoint = xform3 c_tcutg_setpoint
instance ITNamed TCutG where
  setName = xform1 c_tcutg_setname
  setNameTitle = xform2 c_tcutg_setnametitle
  setTitle = xform1 c_tcutg_settitle
instance ITAttLine TCutG where
  getLineColor = xform0 c_tcutg_getlinecolor
  getLineStyle = xform0 c_tcutg_getlinestyle
  getLineWidth = xform0 c_tcutg_getlinewidth
  resetAttLine = xform1 c_tcutg_resetattline
  setLineAttributes = xform0 c_tcutg_setlineattributes
  setLineColor = xform1 c_tcutg_setlinecolor
  setLineStyle = xform1 c_tcutg_setlinestyle
  setLineWidth = xform1 c_tcutg_setlinewidth
instance ITAttFill TCutG where
  setFillColor = xform1 c_tcutg_setfillcolor
  setFillStyle = xform1 c_tcutg_setfillstyle
instance ITAttMarker TCutG where
  getMarkerColor = xform0 c_tcutg_getmarkercolor
  getMarkerStyle = xform0 c_tcutg_getmarkerstyle
  getMarkerSize = xform0 c_tcutg_getmarkersize
  resetAttMarker = xform1 c_tcutg_resetattmarker
  setMarkerAttributes = xform0 c_tcutg_setmarkerattributes
  setMarkerColor = xform1 c_tcutg_setmarkercolor
  setMarkerStyle = xform1 c_tcutg_setmarkerstyle
  setMarkerSize = xform1 c_tcutg_setmarkersize
instance ITObject TCutG where
  draw = xform1 c_tcutg_draw
  findObject = xform1 c_tcutg_findobject
  getName = xform0 c_tcutg_getname
  isA = xform0 c_tcutg_isa
  paint = xform1 c_tcutg_paint
  printObj = xform1 c_tcutg_printobj
  saveAs = xform2 c_tcutg_saveas
  write = xform3 c_tcutg_write
instance IDeletable TCutG where
  delete = xform0 c_tcutg_delete

instance ITCutG (Exist TCutG) where

instance ITGraph (Exist TCutG) where
  apply (ETCutG x) = apply x
  chisquare (ETCutG x) = chisquare x
  drawGraph (ETCutG x) = drawGraph x
  drawPanelTGraph (ETCutG x) = drawPanelTGraph x
  expand (ETCutG x) = expand x
  fitPanelTGraph (ETCutG x) = fitPanelTGraph x
  getCorrelationFactorTGraph (ETCutG x) = getCorrelationFactorTGraph x
  getCovarianceTGraph (ETCutG x) = getCovarianceTGraph x
  getMeanTGraph (ETCutG x) = getMeanTGraph x
  getRMSTGraph (ETCutG x) = getRMSTGraph x
  getErrorX (ETCutG x) = getErrorX x
  getErrorY (ETCutG x) = getErrorY x
  getErrorXhigh (ETCutG x) = getErrorXhigh x
  getErrorXlow (ETCutG x) = getErrorXlow x
  getErrorYhigh (ETCutG x) = getErrorYhigh x
  getErrorYlow (ETCutG x) = getErrorYlow x
  initExpo (ETCutG x) = initExpo x
  initGaus (ETCutG x) = initGaus x
  initPolynom (ETCutG x) = initPolynom x
  insertPoint (ETCutG x) = insertPoint x
  integralTGraph (ETCutG x) = integralTGraph x
  isEditable (ETCutG x) = isEditable x
  isInsideTGraph (ETCutG x) = isInsideTGraph x
  leastSquareFit (ETCutG x) = leastSquareFit x
  paintStats (ETCutG x) = paintStats x
  removePoint (ETCutG x) = removePoint x
  setEditable (ETCutG x) = setEditable x
  setHistogram (ETCutG x) = setHistogram x
  setMaximumTGraph (ETCutG x) = setMaximumTGraph x
  setMinimumTGraph (ETCutG x) = setMinimumTGraph x
  set (ETCutG x) = set x
  setPoint (ETCutG x) = setPoint x
instance ITNamed (Exist TCutG) where
  setName (ETCutG x) = setName x
  setNameTitle (ETCutG x) = setNameTitle x
  setTitle (ETCutG x) = setTitle x
instance ITAttLine (Exist TCutG) where
  getLineColor (ETCutG x) = getLineColor x
  getLineStyle (ETCutG x) = getLineStyle x
  getLineWidth (ETCutG x) = getLineWidth x
  resetAttLine (ETCutG x) = resetAttLine x
  setLineAttributes (ETCutG x) = setLineAttributes x
  setLineColor (ETCutG x) = setLineColor x
  setLineStyle (ETCutG x) = setLineStyle x
  setLineWidth (ETCutG x) = setLineWidth x
instance ITAttFill (Exist TCutG) where
  setFillColor (ETCutG x) = setFillColor x
  setFillStyle (ETCutG x) = setFillStyle x
instance ITAttMarker (Exist TCutG) where
  getMarkerColor (ETCutG x) = getMarkerColor x
  getMarkerStyle (ETCutG x) = getMarkerStyle x
  getMarkerSize (ETCutG x) = getMarkerSize x
  resetAttMarker (ETCutG x) = resetAttMarker x
  setMarkerAttributes (ETCutG x) = setMarkerAttributes x
  setMarkerColor (ETCutG x) = setMarkerColor x
  setMarkerStyle (ETCutG x) = setMarkerStyle x
  setMarkerSize (ETCutG x) = setMarkerSize x
instance ITObject (Exist TCutG) where
  draw (ETCutG x) = draw x
  findObject (ETCutG x) = findObject x
  getName (ETCutG x) = getName x
  isA (ETCutG x) = isA x
  paint (ETCutG x) = paint x
  printObj (ETCutG x) = printObj x
  saveAs (ETCutG x) = saveAs x
  write (ETCutG x) = write x
instance IDeletable (Exist TCutG) where
  delete (ETCutG x) = delete x


newTCutG :: CString -> CInt -> (Ptr CDouble) -> (Ptr CDouble) -> IO TCutG
newTCutG = xform3 c_tcutg_newtcutg





instance FPtr (Exist TCutG) where
  type Raw (Exist TCutG) = RawTCutG
  get_fptr (ETCutG obj) = castForeignPtr (get_fptr obj)
  cast_fptr_to_obj fptr = ETCutG (cast_fptr_to_obj (fptr :: ForeignPtr RawTCutG) :: TCutG)
