{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, 
             EmptyDataDecls, ExistentialQuantification, ScopedTypeVariables #-}

-- module HROOT.Class.Interface where

module HROOT.Graf.TCutG.Interface where


import Data.Word
import Foreign.C
import Foreign.Ptr
import Foreign.ForeignPtr
import FFICXX.Runtime.Cast

import HROOT.Graf.TCutG.RawType

import HROOT.Hist.TGraph.Interface
---- ============ ----



class (ITGraph a) => ITCutG a where

instance Existable TCutG where
  data Exist TCutG = forall a. (FPtr a, ITCutG a) => ETCutG a

upcastTCutG :: (FPtr a, ITCutG a) => a -> TCutG
upcastTCutG h = let fh = get_fptr h
                    fh2 :: ForeignPtr RawTCutG = castForeignPtr fh
                in cast_fptr_to_obj fh2

downcastTCutG :: (FPtr a, ITCutG a) => TCutG -> a 
downcastTCutG h = let fh = get_fptr h
                      fh2 = castForeignPtr fh
                  in cast_fptr_to_obj fh2
