{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, EmptyDataDecls, 
             OverlappingInstances, IncoherentInstances #-}

module HROOT.Graf.TEllipse.Implementation where


import FFICXX.Runtime.Cast

import HROOT.Graf.TEllipse.RawType
import HROOT.Graf.TEllipse.FFI
import HROOT.Graf.TEllipse.Interface
import HROOT.Graf.TEllipse.Cast
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import HROOT.Core.TAttLine.RawType
import HROOT.Core.TAttLine.Cast
import HROOT.Core.TAttLine.Interface
import HROOT.Core.TAttFill.RawType
import HROOT.Core.TAttFill.Cast
import HROOT.Core.TAttFill.Interface
import HROOT.Core.Deletable.RawType
import HROOT.Core.Deletable.Cast
import HROOT.Core.Deletable.Interface

import Data.Word
import Foreign.C
import Foreign.Ptr 
import Foreign.ForeignPtr

import System.IO.Unsafe


instance ITEllipse TEllipse where
instance ITObject TEllipse where
  draw = xform1 c_tellipse_draw
  findObject = xform1 c_tellipse_findobject
  getName = xform0 c_tellipse_getname
  isA = xform0 c_tellipse_isa
  paint = xform1 c_tellipse_paint
  printObj = xform1 c_tellipse_printobj
  saveAs = xform2 c_tellipse_saveas
  write = xform3 c_tellipse_write
instance ITAttLine TEllipse where
  getLineColor = xform0 c_tellipse_getlinecolor
  getLineStyle = xform0 c_tellipse_getlinestyle
  getLineWidth = xform0 c_tellipse_getlinewidth
  resetAttLine = xform1 c_tellipse_resetattline
  setLineAttributes = xform0 c_tellipse_setlineattributes
  setLineColor = xform1 c_tellipse_setlinecolor
  setLineStyle = xform1 c_tellipse_setlinestyle
  setLineWidth = xform1 c_tellipse_setlinewidth
instance ITAttFill TEllipse where
  setFillColor = xform1 c_tellipse_setfillcolor
  setFillStyle = xform1 c_tellipse_setfillstyle
instance IDeletable TEllipse where
  delete = xform0 c_tellipse_delete

instance ITEllipse (Exist TEllipse) where

instance ITObject (Exist TEllipse) where
  draw (ETEllipse x) = draw x
  findObject (ETEllipse x) = findObject x
  getName (ETEllipse x) = getName x
  isA (ETEllipse x) = isA x
  paint (ETEllipse x) = paint x
  printObj (ETEllipse x) = printObj x
  saveAs (ETEllipse x) = saveAs x
  write (ETEllipse x) = write x
instance ITAttLine (Exist TEllipse) where
  getLineColor (ETEllipse x) = getLineColor x
  getLineStyle (ETEllipse x) = getLineStyle x
  getLineWidth (ETEllipse x) = getLineWidth x
  resetAttLine (ETEllipse x) = resetAttLine x
  setLineAttributes (ETEllipse x) = setLineAttributes x
  setLineColor (ETEllipse x) = setLineColor x
  setLineStyle (ETEllipse x) = setLineStyle x
  setLineWidth (ETEllipse x) = setLineWidth x
instance ITAttFill (Exist TEllipse) where
  setFillColor (ETEllipse x) = setFillColor x
  setFillStyle (ETEllipse x) = setFillStyle x
instance IDeletable (Exist TEllipse) where
  delete (ETEllipse x) = delete x


newTEllipse :: CDouble -> CDouble -> CDouble -> CDouble -> CDouble -> CDouble -> CDouble -> IO TEllipse
newTEllipse = xform6 c_tellipse_newtellipse





instance FPtr (Exist TEllipse) where
  type Raw (Exist TEllipse) = RawTEllipse
  get_fptr (ETEllipse obj) = castForeignPtr (get_fptr obj)
  cast_fptr_to_obj fptr = ETEllipse (cast_fptr_to_obj (fptr :: ForeignPtr RawTEllipse) :: TEllipse)
