{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, 
             EmptyDataDecls, ExistentialQuantification, ScopedTypeVariables #-}

-- module HROOT.Class.Interface where

module HROOT.Graf.TEllipse.Interface where


import Data.Word
import Foreign.C
import Foreign.Ptr
import Foreign.ForeignPtr
import FFICXX.Runtime.Cast

import HROOT.Graf.TEllipse.RawType

import HROOT.Core.TObject.Interface
import HROOT.Core.TAttLine.Interface
import HROOT.Core.TAttFill.Interface
---- ============ ----



class (ITObject a,ITAttLine a,ITAttFill a) => ITEllipse a where

instance Existable TEllipse where
  data Exist TEllipse = forall a. (FPtr a, ITEllipse a) => ETEllipse a

upcastTEllipse :: (FPtr a, ITEllipse a) => a -> TEllipse
upcastTEllipse h = let fh = get_fptr h
                       fh2 :: ForeignPtr RawTEllipse = castForeignPtr fh
                   in cast_fptr_to_obj fh2

downcastTEllipse :: (FPtr a, ITEllipse a) => TEllipse -> a 
downcastTEllipse h = let fh = get_fptr h
                         fh2 = castForeignPtr fh
                     in cast_fptr_to_obj fh2
