{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, EmptyDataDecls, 
             OverlappingInstances, IncoherentInstances #-}

module HROOT.Graf.TGaxis.Implementation where


import FFICXX.Runtime.Cast

import HROOT.Graf.TGaxis.RawType
import HROOT.Graf.TGaxis.FFI
import HROOT.Graf.TGaxis.Interface
import HROOT.Graf.TGaxis.Cast
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Graf.TLine.RawType
import HROOT.Graf.TLine.Cast
import HROOT.Graf.TLine.Interface
import HROOT.Core.TAttText.RawType
import HROOT.Core.TAttText.Cast
import HROOT.Core.TAttText.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import HROOT.Core.TAttLine.RawType
import HROOT.Core.TAttLine.Cast
import HROOT.Core.TAttLine.Interface
import HROOT.Core.Deletable.RawType
import HROOT.Core.Deletable.Cast
import HROOT.Core.Deletable.Interface

import Data.Word
import Foreign.C
import Foreign.Ptr 
import Foreign.ForeignPtr

import System.IO.Unsafe


instance ITGaxis TGaxis where
instance ITLine TGaxis where
  drawLine = xform4 c_tgaxis_drawline
  drawLineNDC = xform4 c_tgaxis_drawlinendc
  paintLine = xform4 c_tgaxis_paintline
  paintLineNDC = xform4 c_tgaxis_paintlinendc
  setX1 = xform1 c_tgaxis_setx1
  setX2 = xform1 c_tgaxis_setx2
  setY1 = xform1 c_tgaxis_sety1
  setY2 = xform1 c_tgaxis_sety2
instance ITAttText TGaxis where
  getTextAlign = xform0 c_tgaxis_gettextalign
  getTextAngle = xform0 c_tgaxis_gettextangle
  getTextColor = xform0 c_tgaxis_gettextcolor
  getTextFont = xform0 c_tgaxis_gettextfont
  getTextSize = xform0 c_tgaxis_gettextsize
  resetAttText = xform1 c_tgaxis_resetatttext
  setTextAttributes = xform0 c_tgaxis_settextattributes
  setTextAlign = xform1 c_tgaxis_settextalign
  setTextAngle = xform1 c_tgaxis_settextangle
  setTextColor = xform1 c_tgaxis_settextcolor
  setTextFont = xform1 c_tgaxis_settextfont
  setTextSize = xform1 c_tgaxis_settextsize
  setTextSizePixels = xform1 c_tgaxis_settextsizepixels
instance ITObject TGaxis where
  draw = xform1 c_tgaxis_draw
  findObject = xform1 c_tgaxis_findobject
  getName = xform0 c_tgaxis_getname
  isA = xform0 c_tgaxis_isa
  paint = xform1 c_tgaxis_paint
  printObj = xform1 c_tgaxis_printobj
  saveAs = xform2 c_tgaxis_saveas
  write = xform3 c_tgaxis_write
instance ITAttLine TGaxis where
  getLineColor = xform0 c_tgaxis_getlinecolor
  getLineStyle = xform0 c_tgaxis_getlinestyle
  getLineWidth = xform0 c_tgaxis_getlinewidth
  resetAttLine = xform1 c_tgaxis_resetattline
  setLineAttributes = xform0 c_tgaxis_setlineattributes
  setLineColor = xform1 c_tgaxis_setlinecolor
  setLineStyle = xform1 c_tgaxis_setlinestyle
  setLineWidth = xform1 c_tgaxis_setlinewidth
instance IDeletable TGaxis where
  delete = xform0 c_tgaxis_delete

instance ITGaxis (Exist TGaxis) where

instance ITLine (Exist TGaxis) where
  drawLine (ETGaxis x) = drawLine x
  drawLineNDC (ETGaxis x) = drawLineNDC x
  paintLine (ETGaxis x) = paintLine x
  paintLineNDC (ETGaxis x) = paintLineNDC x
  setX1 (ETGaxis x) = setX1 x
  setX2 (ETGaxis x) = setX2 x
  setY1 (ETGaxis x) = setY1 x
  setY2 (ETGaxis x) = setY2 x
instance ITAttText (Exist TGaxis) where
  getTextAlign (ETGaxis x) = getTextAlign x
  getTextAngle (ETGaxis x) = getTextAngle x
  getTextColor (ETGaxis x) = getTextColor x
  getTextFont (ETGaxis x) = getTextFont x
  getTextSize (ETGaxis x) = getTextSize x
  resetAttText (ETGaxis x) = resetAttText x
  setTextAttributes (ETGaxis x) = setTextAttributes x
  setTextAlign (ETGaxis x) = setTextAlign x
  setTextAngle (ETGaxis x) = setTextAngle x
  setTextColor (ETGaxis x) = setTextColor x
  setTextFont (ETGaxis x) = setTextFont x
  setTextSize (ETGaxis x) = setTextSize x
  setTextSizePixels (ETGaxis x) = setTextSizePixels x
instance ITObject (Exist TGaxis) where
  draw (ETGaxis x) = draw x
  findObject (ETGaxis x) = findObject x
  getName (ETGaxis x) = getName x
  isA (ETGaxis x) = isA x
  paint (ETGaxis x) = paint x
  printObj (ETGaxis x) = printObj x
  saveAs (ETGaxis x) = saveAs x
  write (ETGaxis x) = write x
instance ITAttLine (Exist TGaxis) where
  getLineColor (ETGaxis x) = getLineColor x
  getLineStyle (ETGaxis x) = getLineStyle x
  getLineWidth (ETGaxis x) = getLineWidth x
  resetAttLine (ETGaxis x) = resetAttLine x
  setLineAttributes (ETGaxis x) = setLineAttributes x
  setLineColor (ETGaxis x) = setLineColor x
  setLineStyle (ETGaxis x) = setLineStyle x
  setLineWidth (ETGaxis x) = setLineWidth x
instance IDeletable (Exist TGaxis) where
  delete (ETGaxis x) = delete x


newTGaxis :: CDouble -> CDouble -> CDouble -> CDouble -> CDouble -> CDouble -> CInt -> CString -> CDouble -> IO TGaxis
newTGaxis = xform8 c_tgaxis_newtgaxis





instance FPtr (Exist TGaxis) where
  type Raw (Exist TGaxis) = RawTGaxis
  get_fptr (ETGaxis obj) = castForeignPtr (get_fptr obj)
  cast_fptr_to_obj fptr = ETGaxis (cast_fptr_to_obj (fptr :: ForeignPtr RawTGaxis) :: TGaxis)
