{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, 
             EmptyDataDecls, ExistentialQuantification, ScopedTypeVariables #-}

-- module HROOT.Class.Interface where

module HROOT.Graf.TGaxis.Interface where


import Data.Word
import Foreign.C
import Foreign.Ptr
import Foreign.ForeignPtr
import FFICXX.Runtime.Cast

import HROOT.Graf.TGaxis.RawType

import HROOT.Graf.TLine.Interface
import HROOT.Core.TAttText.Interface
---- ============ ----



class (ITLine a,ITAttText a) => ITGaxis a where

instance Existable TGaxis where
  data Exist TGaxis = forall a. (FPtr a, ITGaxis a) => ETGaxis a

upcastTGaxis :: (FPtr a, ITGaxis a) => a -> TGaxis
upcastTGaxis h = let fh = get_fptr h
                     fh2 :: ForeignPtr RawTGaxis = castForeignPtr fh
                 in cast_fptr_to_obj fh2

downcastTGaxis :: (FPtr a, ITGaxis a) => TGaxis -> a 
downcastTGaxis h = let fh = get_fptr h
                       fh2 = castForeignPtr fh
                   in cast_fptr_to_obj fh2
