{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, 
             EmptyDataDecls, ExistentialQuantification, ScopedTypeVariables #-}

-- module HROOT.Class.Interface where

module HROOT.Graf.TGraphQQ.Interface where


import Data.Word
import Foreign.C
import Foreign.Ptr
import Foreign.ForeignPtr
import FFICXX.Runtime.Cast

import HROOT.Graf.TGraphQQ.RawType

import HROOT.Hist.TGraph.Interface
---- ============ ----



class (ITGraph a) => ITGraphQQ a where

instance Existable TGraphQQ where
  data Exist TGraphQQ = forall a. (FPtr a, ITGraphQQ a) => ETGraphQQ a

upcastTGraphQQ :: (FPtr a, ITGraphQQ a) => a -> TGraphQQ
upcastTGraphQQ h = let fh = get_fptr h
                       fh2 :: ForeignPtr RawTGraphQQ = castForeignPtr fh
                   in cast_fptr_to_obj fh2

downcastTGraphQQ :: (FPtr a, ITGraphQQ a) => TGraphQQ -> a 
downcastTGraphQQ h = let fh = get_fptr h
                         fh2 = castForeignPtr fh
                     in cast_fptr_to_obj fh2
