{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, EmptyDataDecls, 
             OverlappingInstances, IncoherentInstances #-}

module HROOT.Graf.TLine.Implementation where


import FFICXX.Runtime.Cast

import HROOT.Graf.TLine.RawType
import HROOT.Graf.TLine.FFI
import HROOT.Graf.TLine.Interface
import HROOT.Graf.TLine.Cast
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import HROOT.Core.TAttLine.RawType
import HROOT.Core.TAttLine.Cast
import HROOT.Core.TAttLine.Interface
import HROOT.Core.Deletable.RawType
import HROOT.Core.Deletable.Cast
import HROOT.Core.Deletable.Interface

import Data.Word
import Foreign.C
import Foreign.Ptr 
import Foreign.ForeignPtr

import System.IO.Unsafe


instance ITLine TLine where
  drawLine = xform4 c_tline_drawline
  drawLineNDC = xform4 c_tline_drawlinendc
  paintLine = xform4 c_tline_paintline
  paintLineNDC = xform4 c_tline_paintlinendc
  setX1 = xform1 c_tline_setx1
  setX2 = xform1 c_tline_setx2
  setY1 = xform1 c_tline_sety1
  setY2 = xform1 c_tline_sety2
instance ITObject TLine where
  draw = xform1 c_tline_draw
  findObject = xform1 c_tline_findobject
  getName = xform0 c_tline_getname
  isA = xform0 c_tline_isa
  paint = xform1 c_tline_paint
  printObj = xform1 c_tline_printobj
  saveAs = xform2 c_tline_saveas
  write = xform3 c_tline_write
instance ITAttLine TLine where
  getLineColor = xform0 c_tline_getlinecolor
  getLineStyle = xform0 c_tline_getlinestyle
  getLineWidth = xform0 c_tline_getlinewidth
  resetAttLine = xform1 c_tline_resetattline
  setLineAttributes = xform0 c_tline_setlineattributes
  setLineColor = xform1 c_tline_setlinecolor
  setLineStyle = xform1 c_tline_setlinestyle
  setLineWidth = xform1 c_tline_setlinewidth
instance IDeletable TLine where
  delete = xform0 c_tline_delete

instance ITLine (Exist TLine) where
  drawLine (ETLine x) = drawLine x
  drawLineNDC (ETLine x) = drawLineNDC x
  paintLine (ETLine x) = paintLine x
  paintLineNDC (ETLine x) = paintLineNDC x
  setX1 (ETLine x) = setX1 x
  setX2 (ETLine x) = setX2 x
  setY1 (ETLine x) = setY1 x
  setY2 (ETLine x) = setY2 x
instance ITObject (Exist TLine) where
  draw (ETLine x) = draw x
  findObject (ETLine x) = findObject x
  getName (ETLine x) = getName x
  isA (ETLine x) = isA x
  paint (ETLine x) = paint x
  printObj (ETLine x) = printObj x
  saveAs (ETLine x) = saveAs x
  write (ETLine x) = write x
instance ITAttLine (Exist TLine) where
  getLineColor (ETLine x) = getLineColor x
  getLineStyle (ETLine x) = getLineStyle x
  getLineWidth (ETLine x) = getLineWidth x
  resetAttLine (ETLine x) = resetAttLine x
  setLineAttributes (ETLine x) = setLineAttributes x
  setLineColor (ETLine x) = setLineColor x
  setLineStyle (ETLine x) = setLineStyle x
  setLineWidth (ETLine x) = setLineWidth x
instance IDeletable (Exist TLine) where
  delete (ETLine x) = delete x


newTLine :: CDouble -> CDouble -> CDouble -> CDouble -> IO TLine
newTLine = xform3 c_tline_newtline

tLineGetX1 :: TLine -> IO CDouble
tLineGetX1 = xform0 c_tline_tlinegetx1

tLineGetX2 :: TLine -> IO CDouble
tLineGetX2 = xform0 c_tline_tlinegetx2

tLineGetY1 :: TLine -> IO CDouble
tLineGetY1 = xform0 c_tline_tlinegety1

tLineGetY2 :: TLine -> IO CDouble
tLineGetY2 = xform0 c_tline_tlinegety2

tLineIsHorizontal :: TLine -> IO CInt
tLineIsHorizontal = xform0 c_tline_tlineishorizontal

tLineIsVertical :: TLine -> IO CInt
tLineIsVertical = xform0 c_tline_tlineisvertical

tLineSetHorizontal :: TLine -> CInt -> IO ()
tLineSetHorizontal = xform1 c_tline_tlinesethorizontal

tLineSetVertical :: TLine -> CInt -> IO ()
tLineSetVertical = xform1 c_tline_tlinesetvertical



instance FPtr (Exist TLine) where
  type Raw (Exist TLine) = RawTLine
  get_fptr (ETLine obj) = castForeignPtr (get_fptr obj)
  cast_fptr_to_obj fptr = ETLine (cast_fptr_to_obj (fptr :: ForeignPtr RawTLine) :: TLine)
