{-# LANGUAGE FlexibleInstances, FlexibleContexts, TypeFamilies, 
             MultiParamTypeClasses, OverlappingInstances, IncoherentInstances #-}

module HROOT.Graf.TPCON.Cast where


import Foreign.Ptr
import Foreign.ForeignPtr (castForeignPtr, newForeignPtr_)
import Foreign.ForeignPtr.Unsafe
import FFICXX.Runtime.Cast
import System.IO.Unsafe

import HROOT.Graf.TPCON.RawType
import HROOT.Graf.TPCON.Interface

instance (ITPCON a, FPtr a) => Castable a (Ptr RawTPCON) where
  cast = unsafeForeignPtrToPtr . castForeignPtr . get_fptr
  uncast = cast_fptr_to_obj . castForeignPtr . unsafePerformIO . newForeignPtr_ 

instance Castable TPCON (Ptr RawTPCON) where
  cast = unsafeForeignPtrToPtr . castForeignPtr . get_fptr
  uncast = cast_fptr_to_obj . castForeignPtr . unsafePerformIO . newForeignPtr_ 
