{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, 
             EmptyDataDecls, ExistentialQuantification, ScopedTypeVariables #-}

-- module HROOT.Class.Interface where

module HROOT.Graf.TPCON.Interface where


import Data.Word
import Foreign.C
import Foreign.Ptr
import Foreign.ForeignPtr
import FFICXX.Runtime.Cast

import HROOT.Graf.TPCON.RawType

import HROOT.Graf.TShape.Interface
---- ============ ----



class (ITShape a) => ITPCON a where

instance Existable TPCON where
  data Exist TPCON = forall a. (FPtr a, ITPCON a) => ETPCON a

upcastTPCON :: (FPtr a, ITPCON a) => a -> TPCON
upcastTPCON h = let fh = get_fptr h
                    fh2 :: ForeignPtr RawTPCON = castForeignPtr fh
                in cast_fptr_to_obj fh2

downcastTPCON :: (FPtr a, ITPCON a) => TPCON -> a 
downcastTPCON h = let fh = get_fptr h
                      fh2 = castForeignPtr fh
                  in cast_fptr_to_obj fh2
