{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, EmptyDataDecls, 
             OverlappingInstances, IncoherentInstances #-}

module HROOT.Graf.TPad.Implementation where


import FFICXX.Runtime.Cast

import HROOT.Graf.TPad.RawType
import HROOT.Graf.TPad.FFI
import HROOT.Graf.TPad.Interface
import HROOT.Graf.TPad.Cast
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Core.TVirtualPad.RawType
import HROOT.Core.TVirtualPad.Cast
import HROOT.Core.TVirtualPad.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import HROOT.Core.Deletable.RawType
import HROOT.Core.Deletable.Cast
import HROOT.Core.Deletable.Interface

import Data.Word
import Foreign.C
import Foreign.Ptr 
import Foreign.ForeignPtr

import System.IO.Unsafe


instance ITPad TPad where
instance ITVirtualPad TPad where
  cd = xform1 c_tpad_cd
  divide_tvirtualpad = xform5 c_tpad_divide_tvirtualpad
  setLogx = xform1 c_tpad_setlogx
  setLogy = xform1 c_tpad_setlogy
  setLogz = xform1 c_tpad_setlogz
instance ITObject TPad where
  draw = xform1 c_tpad_draw
  findObject = xform1 c_tpad_findobject
  getName = xform0 c_tpad_getname
  isA = xform0 c_tpad_isa
  paint = xform1 c_tpad_paint
  printObj = xform1 c_tpad_printobj
  saveAs = xform2 c_tpad_saveas
  write = xform3 c_tpad_write
instance IDeletable TPad where
  delete = xform0 c_tpad_delete

instance ITPad (Exist TPad) where

instance ITVirtualPad (Exist TPad) where
  cd (ETPad x) a1 = return . ETPad =<< cd x a1
  divide_tvirtualpad (ETPad x) = divide_tvirtualpad x
  setLogx (ETPad x) = setLogx x
  setLogy (ETPad x) = setLogy x
  setLogz (ETPad x) = setLogz x
instance ITObject (Exist TPad) where
  draw (ETPad x) = draw x
  findObject (ETPad x) = findObject x
  getName (ETPad x) = getName x
  isA (ETPad x) = isA x
  paint (ETPad x) = paint x
  printObj (ETPad x) = printObj x
  saveAs (ETPad x) = saveAs x
  write (ETPad x) = write x
instance IDeletable (Exist TPad) where
  delete (ETPad x) = delete x







instance FPtr (Exist TPad) where
  type Raw (Exist TPad) = RawTPad
  get_fptr (ETPad obj) = castForeignPtr (get_fptr obj)
  cast_fptr_to_obj fptr = ETPad (cast_fptr_to_obj (fptr :: ForeignPtr RawTPad) :: TPad)
