{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, 
             EmptyDataDecls, ExistentialQuantification, ScopedTypeVariables #-}

-- module HROOT.Class.Interface where

module HROOT.Graf.TPad.Interface where


import Data.Word
import Foreign.C
import Foreign.Ptr
import Foreign.ForeignPtr
import FFICXX.Runtime.Cast

import HROOT.Graf.TPad.RawType

import HROOT.Core.TVirtualPad.Interface
---- ============ ----



class (ITVirtualPad a) => ITPad a where

instance Existable TPad where
  data Exist TPad = forall a. (FPtr a, ITPad a) => ETPad a

upcastTPad :: (FPtr a, ITPad a) => a -> TPad
upcastTPad h = let fh = get_fptr h
                   fh2 :: ForeignPtr RawTPad = castForeignPtr fh
               in cast_fptr_to_obj fh2

downcastTPad :: (FPtr a, ITPad a) => TPad -> a 
downcastTPad h = let fh = get_fptr h
                     fh2 = castForeignPtr fh
                 in cast_fptr_to_obj fh2
