{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, EmptyDataDecls, 
             OverlappingInstances, IncoherentInstances #-}

module HROOT.Graf.TSPHE.Implementation where


import FFICXX.Runtime.Cast

import HROOT.Graf.TSPHE.RawType
import HROOT.Graf.TSPHE.FFI
import HROOT.Graf.TSPHE.Interface
import HROOT.Graf.TSPHE.Cast
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Graf.TShape.RawType
import HROOT.Graf.TShape.Cast
import HROOT.Graf.TShape.Interface
import HROOT.Core.TNamed.RawType
import HROOT.Core.TNamed.Cast
import HROOT.Core.TNamed.Interface
import HROOT.Core.TAttLine.RawType
import HROOT.Core.TAttLine.Cast
import HROOT.Core.TAttLine.Interface
import HROOT.Core.TAttFill.RawType
import HROOT.Core.TAttFill.Cast
import HROOT.Core.TAttFill.Interface
import HROOT.Core.TAtt3D.RawType
import HROOT.Core.TAtt3D.Cast
import HROOT.Core.TAtt3D.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import HROOT.Core.Deletable.RawType
import HROOT.Core.Deletable.Cast
import HROOT.Core.Deletable.Interface

import Data.Word
import Foreign.C
import Foreign.Ptr 
import Foreign.ForeignPtr

import System.IO.Unsafe


instance ITSPHE TSPHE where
instance ITShape TSPHE where
instance ITNamed TSPHE where
  setName = xform1 c_tsphe_setname
  setNameTitle = xform2 c_tsphe_setnametitle
  setTitle = xform1 c_tsphe_settitle
instance ITAttLine TSPHE where
  getLineColor = xform0 c_tsphe_getlinecolor
  getLineStyle = xform0 c_tsphe_getlinestyle
  getLineWidth = xform0 c_tsphe_getlinewidth
  resetAttLine = xform1 c_tsphe_resetattline
  setLineAttributes = xform0 c_tsphe_setlineattributes
  setLineColor = xform1 c_tsphe_setlinecolor
  setLineStyle = xform1 c_tsphe_setlinestyle
  setLineWidth = xform1 c_tsphe_setlinewidth
instance ITAttFill TSPHE where
  setFillColor = xform1 c_tsphe_setfillcolor
  setFillStyle = xform1 c_tsphe_setfillstyle
instance ITAtt3D TSPHE where
instance ITObject TSPHE where
  draw = xform1 c_tsphe_draw
  findObject = xform1 c_tsphe_findobject
  getName = xform0 c_tsphe_getname
  isA = xform0 c_tsphe_isa
  paint = xform1 c_tsphe_paint
  printObj = xform1 c_tsphe_printobj
  saveAs = xform2 c_tsphe_saveas
  write = xform3 c_tsphe_write
instance IDeletable TSPHE where
  delete = xform0 c_tsphe_delete

instance ITSPHE (Exist TSPHE) where

instance ITShape (Exist TSPHE) where

instance ITNamed (Exist TSPHE) where
  setName (ETSPHE x) = setName x
  setNameTitle (ETSPHE x) = setNameTitle x
  setTitle (ETSPHE x) = setTitle x
instance ITAttLine (Exist TSPHE) where
  getLineColor (ETSPHE x) = getLineColor x
  getLineStyle (ETSPHE x) = getLineStyle x
  getLineWidth (ETSPHE x) = getLineWidth x
  resetAttLine (ETSPHE x) = resetAttLine x
  setLineAttributes (ETSPHE x) = setLineAttributes x
  setLineColor (ETSPHE x) = setLineColor x
  setLineStyle (ETSPHE x) = setLineStyle x
  setLineWidth (ETSPHE x) = setLineWidth x
instance ITAttFill (Exist TSPHE) where
  setFillColor (ETSPHE x) = setFillColor x
  setFillStyle (ETSPHE x) = setFillStyle x
instance ITAtt3D (Exist TSPHE) where

instance ITObject (Exist TSPHE) where
  draw (ETSPHE x) = draw x
  findObject (ETSPHE x) = findObject x
  getName (ETSPHE x) = getName x
  isA (ETSPHE x) = isA x
  paint (ETSPHE x) = paint x
  printObj (ETSPHE x) = printObj x
  saveAs (ETSPHE x) = saveAs x
  write (ETSPHE x) = write x
instance IDeletable (Exist TSPHE) where
  delete (ETSPHE x) = delete x


newTSPHE :: CString -> CString -> CString -> CDouble -> CDouble -> CDouble -> CDouble -> CDouble -> CDouble -> IO TSPHE
newTSPHE = xform8 c_tsphe_newtsphe





instance FPtr (Exist TSPHE) where
  type Raw (Exist TSPHE) = RawTSPHE
  get_fptr (ETSPHE obj) = castForeignPtr (get_fptr obj)
  cast_fptr_to_obj fptr = ETSPHE (cast_fptr_to_obj (fptr :: ForeignPtr RawTSPHE) :: TSPHE)
