{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, 
             EmptyDataDecls, ExistentialQuantification, ScopedTypeVariables #-}

-- module HROOT.Class.Interface where

module HROOT.Graf.TSPHE.Interface where


import Data.Word
import Foreign.C
import Foreign.Ptr
import Foreign.ForeignPtr
import FFICXX.Runtime.Cast

import HROOT.Graf.TSPHE.RawType

import HROOT.Graf.TShape.Interface
---- ============ ----



class (ITShape a) => ITSPHE a where

instance Existable TSPHE where
  data Exist TSPHE = forall a. (FPtr a, ITSPHE a) => ETSPHE a

upcastTSPHE :: (FPtr a, ITSPHE a) => a -> TSPHE
upcastTSPHE h = let fh = get_fptr h
                    fh2 :: ForeignPtr RawTSPHE = castForeignPtr fh
                in cast_fptr_to_obj fh2

downcastTSPHE :: (FPtr a, ITSPHE a) => TSPHE -> a 
downcastTSPHE h = let fh = get_fptr h
                      fh2 = castForeignPtr fh
                  in cast_fptr_to_obj fh2
