{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, EmptyDataDecls, 
             OverlappingInstances, IncoherentInstances #-}

module HROOT.Graf.TShape.Implementation where


import FFICXX.Runtime.Cast

import HROOT.Graf.TShape.RawType
import HROOT.Graf.TShape.FFI
import HROOT.Graf.TShape.Interface
import HROOT.Graf.TShape.Cast
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Core.TNamed.RawType
import HROOT.Core.TNamed.Cast
import HROOT.Core.TNamed.Interface
import HROOT.Core.TAttLine.RawType
import HROOT.Core.TAttLine.Cast
import HROOT.Core.TAttLine.Interface
import HROOT.Core.TAttFill.RawType
import HROOT.Core.TAttFill.Cast
import HROOT.Core.TAttFill.Interface
import HROOT.Core.TAtt3D.RawType
import HROOT.Core.TAtt3D.Cast
import HROOT.Core.TAtt3D.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import HROOT.Core.Deletable.RawType
import HROOT.Core.Deletable.Cast
import HROOT.Core.Deletable.Interface

import Data.Word
import Foreign.C
import Foreign.Ptr 
import Foreign.ForeignPtr

import System.IO.Unsafe


instance ITShape TShape where
instance ITNamed TShape where
  setName = xform1 c_tshape_setname
  setNameTitle = xform2 c_tshape_setnametitle
  setTitle = xform1 c_tshape_settitle
instance ITAttLine TShape where
  getLineColor = xform0 c_tshape_getlinecolor
  getLineStyle = xform0 c_tshape_getlinestyle
  getLineWidth = xform0 c_tshape_getlinewidth
  resetAttLine = xform1 c_tshape_resetattline
  setLineAttributes = xform0 c_tshape_setlineattributes
  setLineColor = xform1 c_tshape_setlinecolor
  setLineStyle = xform1 c_tshape_setlinestyle
  setLineWidth = xform1 c_tshape_setlinewidth
instance ITAttFill TShape where
  setFillColor = xform1 c_tshape_setfillcolor
  setFillStyle = xform1 c_tshape_setfillstyle
instance ITAtt3D TShape where
instance ITObject TShape where
  draw = xform1 c_tshape_draw
  findObject = xform1 c_tshape_findobject
  getName = xform0 c_tshape_getname
  isA = xform0 c_tshape_isa
  paint = xform1 c_tshape_paint
  printObj = xform1 c_tshape_printobj
  saveAs = xform2 c_tshape_saveas
  write = xform3 c_tshape_write
instance IDeletable TShape where
  delete = xform0 c_tshape_delete

instance ITShape (Exist TShape) where

instance ITNamed (Exist TShape) where
  setName (ETShape x) = setName x
  setNameTitle (ETShape x) = setNameTitle x
  setTitle (ETShape x) = setTitle x
instance ITAttLine (Exist TShape) where
  getLineColor (ETShape x) = getLineColor x
  getLineStyle (ETShape x) = getLineStyle x
  getLineWidth (ETShape x) = getLineWidth x
  resetAttLine (ETShape x) = resetAttLine x
  setLineAttributes (ETShape x) = setLineAttributes x
  setLineColor (ETShape x) = setLineColor x
  setLineStyle (ETShape x) = setLineStyle x
  setLineWidth (ETShape x) = setLineWidth x
instance ITAttFill (Exist TShape) where
  setFillColor (ETShape x) = setFillColor x
  setFillStyle (ETShape x) = setFillStyle x
instance ITAtt3D (Exist TShape) where

instance ITObject (Exist TShape) where
  draw (ETShape x) = draw x
  findObject (ETShape x) = findObject x
  getName (ETShape x) = getName x
  isA (ETShape x) = isA x
  paint (ETShape x) = paint x
  printObj (ETShape x) = printObj x
  saveAs (ETShape x) = saveAs x
  write (ETShape x) = write x
instance IDeletable (Exist TShape) where
  delete (ETShape x) = delete x


newTShape :: CString -> CString -> CString -> IO TShape
newTShape = xform2 c_tshape_newtshape





instance FPtr (Exist TShape) where
  type Raw (Exist TShape) = RawTShape
  get_fptr (ETShape obj) = castForeignPtr (get_fptr obj)
  cast_fptr_to_obj fptr = ETShape (cast_fptr_to_obj (fptr :: ForeignPtr RawTShape) :: TShape)
