{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, 
             EmptyDataDecls, ExistentialQuantification, ScopedTypeVariables #-}

-- module HROOT.Class.Interface where

module HROOT.Graf.TShape.Interface where


import Data.Word
import Foreign.C
import Foreign.Ptr
import Foreign.ForeignPtr
import FFICXX.Runtime.Cast

import HROOT.Graf.TShape.RawType

import HROOT.Core.TNamed.Interface
import HROOT.Core.TAttLine.Interface
import HROOT.Core.TAttFill.Interface
import HROOT.Core.TAtt3D.Interface
---- ============ ----



class (ITNamed a,ITAttLine a,ITAttFill a,ITAtt3D a) => ITShape a where

instance Existable TShape where
  data Exist TShape = forall a. (FPtr a, ITShape a) => ETShape a

upcastTShape :: (FPtr a, ITShape a) => a -> TShape
upcastTShape h = let fh = get_fptr h
                     fh2 :: ForeignPtr RawTShape = castForeignPtr fh
                 in cast_fptr_to_obj fh2

downcastTShape :: (FPtr a, ITShape a) => TShape -> a 
downcastTShape h = let fh = get_fptr h
                       fh2 = castForeignPtr fh
                   in cast_fptr_to_obj fh2
