{-# LANGUAGE FlexibleInstances, FlexibleContexts, TypeFamilies, 
             MultiParamTypeClasses, OverlappingInstances, IncoherentInstances #-}

module HROOT.Graf.TTUBE.Cast where


import Foreign.Ptr
import Foreign.ForeignPtr (castForeignPtr, newForeignPtr_)
import Foreign.ForeignPtr.Unsafe
import FFICXX.Runtime.Cast
import System.IO.Unsafe

import HROOT.Graf.TTUBE.RawType
import HROOT.Graf.TTUBE.Interface

instance (ITTUBE a, FPtr a) => Castable a (Ptr RawTTUBE) where
  cast = unsafeForeignPtrToPtr . castForeignPtr . get_fptr
  uncast = cast_fptr_to_obj . castForeignPtr . unsafePerformIO . newForeignPtr_ 

instance Castable TTUBE (Ptr RawTTUBE) where
  cast = unsafeForeignPtrToPtr . castForeignPtr . get_fptr
  uncast = cast_fptr_to_obj . castForeignPtr . unsafePerformIO . newForeignPtr_ 
