{-# LANGUAGE ForeignFunctionInterface, TypeFamilies, MultiParamTypeClasses, 
             FlexibleInstances, TypeSynonymInstances, EmptyDataDecls, 
             OverlappingInstances, IncoherentInstances #-}

module HROOT.Graf.TTUBE.Implementation where


import FFICXX.Runtime.Cast

import HROOT.Graf.TTUBE.RawType
import HROOT.Graf.TTUBE.FFI
import HROOT.Graf.TTUBE.Interface
import HROOT.Graf.TTUBE.Cast
import HROOT.Core.TClass.RawType
import HROOT.Core.TClass.Cast
import HROOT.Core.TClass.Interface
import HROOT.Graf.TShape.RawType
import HROOT.Graf.TShape.Cast
import HROOT.Graf.TShape.Interface
import HROOT.Core.TNamed.RawType
import HROOT.Core.TNamed.Cast
import HROOT.Core.TNamed.Interface
import HROOT.Core.TAttLine.RawType
import HROOT.Core.TAttLine.Cast
import HROOT.Core.TAttLine.Interface
import HROOT.Core.TAttFill.RawType
import HROOT.Core.TAttFill.Cast
import HROOT.Core.TAttFill.Interface
import HROOT.Core.TAtt3D.RawType
import HROOT.Core.TAtt3D.Cast
import HROOT.Core.TAtt3D.Interface
import HROOT.Core.TObject.RawType
import HROOT.Core.TObject.Cast
import HROOT.Core.TObject.Interface
import HROOT.Core.Deletable.RawType
import HROOT.Core.Deletable.Cast
import HROOT.Core.Deletable.Interface

import Data.Word
import Foreign.C
import Foreign.Ptr 
import Foreign.ForeignPtr

import System.IO.Unsafe


instance ITTUBE TTUBE where
instance ITShape TTUBE where
instance ITNamed TTUBE where
  setName = xform1 c_ttube_setname
  setNameTitle = xform2 c_ttube_setnametitle
  setTitle = xform1 c_ttube_settitle
instance ITAttLine TTUBE where
  getLineColor = xform0 c_ttube_getlinecolor
  getLineStyle = xform0 c_ttube_getlinestyle
  getLineWidth = xform0 c_ttube_getlinewidth
  resetAttLine = xform1 c_ttube_resetattline
  setLineAttributes = xform0 c_ttube_setlineattributes
  setLineColor = xform1 c_ttube_setlinecolor
  setLineStyle = xform1 c_ttube_setlinestyle
  setLineWidth = xform1 c_ttube_setlinewidth
instance ITAttFill TTUBE where
  setFillColor = xform1 c_ttube_setfillcolor
  setFillStyle = xform1 c_ttube_setfillstyle
instance ITAtt3D TTUBE where
instance ITObject TTUBE where
  draw = xform1 c_ttube_draw
  findObject = xform1 c_ttube_findobject
  getName = xform0 c_ttube_getname
  isA = xform0 c_ttube_isa
  paint = xform1 c_ttube_paint
  printObj = xform1 c_ttube_printobj
  saveAs = xform2 c_ttube_saveas
  write = xform3 c_ttube_write
instance IDeletable TTUBE where
  delete = xform0 c_ttube_delete

instance ITTUBE (Exist TTUBE) where

instance ITShape (Exist TTUBE) where

instance ITNamed (Exist TTUBE) where
  setName (ETTUBE x) = setName x
  setNameTitle (ETTUBE x) = setNameTitle x
  setTitle (ETTUBE x) = setTitle x
instance ITAttLine (Exist TTUBE) where
  getLineColor (ETTUBE x) = getLineColor x
  getLineStyle (ETTUBE x) = getLineStyle x
  getLineWidth (ETTUBE x) = getLineWidth x
  resetAttLine (ETTUBE x) = resetAttLine x
  setLineAttributes (ETTUBE x) = setLineAttributes x
  setLineColor (ETTUBE x) = setLineColor x
  setLineStyle (ETTUBE x) = setLineStyle x
  setLineWidth (ETTUBE x) = setLineWidth x
instance ITAttFill (Exist TTUBE) where
  setFillColor (ETTUBE x) = setFillColor x
  setFillStyle (ETTUBE x) = setFillStyle x
instance ITAtt3D (Exist TTUBE) where

instance ITObject (Exist TTUBE) where
  draw (ETTUBE x) = draw x
  findObject (ETTUBE x) = findObject x
  getName (ETTUBE x) = getName x
  isA (ETTUBE x) = isA x
  paint (ETTUBE x) = paint x
  printObj (ETTUBE x) = printObj x
  saveAs (ETTUBE x) = saveAs x
  write (ETTUBE x) = write x
instance IDeletable (Exist TTUBE) where
  delete (ETTUBE x) = delete x


newTTUBE :: CString -> CString -> CString -> CDouble -> CDouble -> CDouble -> CDouble -> IO TTUBE
newTTUBE = xform6 c_ttube_newttube





instance FPtr (Exist TTUBE) where
  type Raw (Exist TTUBE) = RawTTUBE
  get_fptr (ETTUBE obj) = castForeignPtr (get_fptr obj)
  cast_fptr_to_obj fptr = ETTUBE (cast_fptr_to_obj (fptr :: ForeignPtr RawTTUBE) :: TTUBE)
